/* $Id: WorkflowDesignerManager.java,v 1.1 2007/10/19 08:19:34 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd;

import javax.swing.ActionMap;

import jp.co.argo21.nautica.commons.swing.ExceptionViewer;
import jp.co.argo21.nautica.commons.swing.HelpViewer;
import jp.co.argo21.nautica.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.action.ActionNames;
import jp.co.argo21.nautica.tool.wfd.action.CopyActivityAction;
import jp.co.argo21.nautica.tool.wfd.action.CutActivityAction;
import jp.co.argo21.nautica.tool.wfd.action.DeleteActivityAction;
import jp.co.argo21.nautica.tool.wfd.action.ExceptionViewerAction;
import jp.co.argo21.nautica.tool.wfd.action.ExitAction;
import jp.co.argo21.nautica.tool.wfd.action.ExpandFlowViewHeightAction;
import jp.co.argo21.nautica.tool.wfd.action.ExpandFlowViewWidthAction;
import jp.co.argo21.nautica.tool.wfd.action.HelpAction;
import jp.co.argo21.nautica.tool.wfd.action.NewPackageAction;
import jp.co.argo21.nautica.tool.wfd.action.OpenPackageAction;
import jp.co.argo21.nautica.tool.wfd.action.PasteActivityAction;
import jp.co.argo21.nautica.tool.wfd.action.PreferencesAction;
import jp.co.argo21.nautica.tool.wfd.action.PrintAction;
import jp.co.argo21.nautica.tool.wfd.action.ReduceFlowViewHeightAction;
import jp.co.argo21.nautica.tool.wfd.action.ReduceFlowViewWidthAction;
import jp.co.argo21.nautica.tool.wfd.action.SavePackageAction;
import jp.co.argo21.nautica.tool.wfd.action.SaveToPackageAction;
import jp.co.argo21.nautica.tool.wfd.action.VersionAction;

/**
 * Nautica WorkflowDesigner全般の管理を行う。
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class WorkflowDesignerManager
{
	/** バンドルパス名 */
	private static final String BUNDLE_PATH
		= "jp.co.argo21.nautica.tool.wfd.resources.messages";

	/** リソースマネージャ */
	private static ResourceManager resourceManager;
	/** メイン画面 */
	private static WorkflowDesignerFrame mainFrame;
	/** 例外ビューア */
	private static ExceptionViewer exceptionViewer;
	/** バージョン画面 */
	private static VersionWindow versionWindow;
	/** ヘルプ画面 */
	private static HelpViewer helpViewer;

	/** アクションマップ */
	private static ActionMap actionMap;
	
	/** ファイルマネージャ */
	private static FileManager fileManager;

	/**
	 * 起動処理を行う。
	 */
	public static void boot() throws Exception
	{
		resourceManager = new ResourceManager(BUNDLE_PATH);

		crerateActionMap();
		
		fileManager = new FileManager();

		versionWindow = new VersionWindow();
		versionWindow.setVisible(true);
		
		//スプラッシュ表示のための1.5秒間の無駄処理
		//long t = System.currentTimeMillis() + 500;
		//while (System.currentTimeMillis() < t) { /* NOP */ }

		mainFrame = new WorkflowDesignerFrame();
		exceptionViewer = new ExceptionViewer(mainFrame, false);
		helpViewer = new HelpViewer();
		mainFrame.newPackage();
		mainFrame.setVisible(true);

		versionWindow.setVisible(false);
	}

	/**
	 * リソースマネージャを返す。
	 *
	 * @return	リソースマネージャ
	 */
	public static ResourceManager getResourceManager()
	{
		return resourceManager;
	}

	/**
	 * 例外ビューアに例外を設定する。
	 * 
	 * @param ex	任意の例外
	 */
	public static void setException(Exception ex)
	{
		exceptionViewer.setThrowable(ex);
	}

	/**
	 * 例外ビューアを返す。
	 * 
	 * @return 例外ビューア
	 */
	public static ExceptionViewer getExceptionViewer()
	{
		return exceptionViewer;
	}

	/**
	 * ヘルプ画面を返す。
	 * 
	 * @return ヘルプ画面
	 */
	public static HelpViewer getHelpViewer()
	{
		return helpViewer;
	}

	/**
	 * メイン画面を返す。
	 * 
	 * @return メイン画面
	 */
	public static WorkflowDesignerFrame getMainFrame()
	{
		return mainFrame;
	}

	/**
	 * バージョン画面を返す。
	 * 
	 * @return バージョン画面
	 */
	public static VersionWindow getVersionWindow()
	{
		return versionWindow;
	}

	/**
	 * アクションマップを返す。
	 * 
	 * @return	アクションマップ
	 */
	public static ActionMap getActionMap()
	{
		return actionMap;
	}

	/**
	 * ファイルマネージャを返す。
	 * 
	 * @return	ファイルマネージャ
	 */
	public static FileManager getFileManager()
	{
		return fileManager;
	}

	/**
	 * アクションマップを作成する。
	 */
	private static void crerateActionMap()
	{
		actionMap = new ActionMap();

		actionMap.put(ActionNames.NEW_PACKAGE,      new NewPackageAction());
		actionMap.put(ActionNames.OPEN_PACKAGE,     new OpenPackageAction());
		actionMap.put(ActionNames.SAVE_PACKAGE,     new SavePackageAction());
		actionMap.put(ActionNames.SAVE_TO_PACKAGE,  new SaveToPackageAction());
		actionMap.put(ActionNames.PRINT_PACKAGE,    new PrintAction());
		actionMap.put(ActionNames.EXIT,             new ExitAction());

		actionMap.put(ActionNames.CUT_ACTIVITY,     new CutActivityAction());
		actionMap.put(ActionNames.COPY_ACTIVITY,    new CopyActivityAction());
		actionMap.put(ActionNames.PASTE_ACTIVITY,   new PasteActivityAction());
		actionMap.put(ActionNames.DELETE_ACTIVITY,  new DeleteActivityAction());

		actionMap.put(ActionNames.EXCEPTION_VIEWER, new ExceptionViewerAction());
		actionMap.put(ActionNames.PREFERENCES,      new PreferencesAction());

		actionMap.put(ActionNames.HELP,             new HelpAction());
		actionMap.put(ActionNames.ABOUT,            new VersionAction());

		actionMap.put(ActionNames.REDUCE_WIDTH,     new ReduceFlowViewWidthAction());
		actionMap.put(ActionNames.REDUCE_HEIGHT,    new ReduceFlowViewHeightAction());
		actionMap.put(ActionNames.EXPAND_WIDTH,     new ExpandFlowViewWidthAction());
		actionMap.put(ActionNames.EXPAND_HEIGHT,    new ExpandFlowViewHeightAction());
	}
}
