/* $Id: ValidationResult.java,v 1.1 2007/10/19 08:19:34 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd;

import jp.co.argo21.nautica.tool.wfd.element.Element;

/**
 * 検証結果
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class ValidationResult
{
	/** エラー */
	public static final int ERROR = 0; 
	/** 警告 */
	public static final int WARNING = 1; 
	
	/** 種別 */
	private int kind;
	/** 要素 */
	private Element element;
	/** メッセージ */
	private String message;

	/**
	 * 検証結果を生成する。
	 * 
	 * @param kind	種別
	 * @param elem	要素
	 * @param msg	メッセージ
	 */
	public ValidationResult(int kind, Element elem, String msg)
	{
		this.kind = kind;
		this.element = elem;
		this.message = msg;
	}

	/**
	 * 要素を返す。
	 * 
	 * @return	要素
	 */
	public Element getElement()
	{
		return element;
	}

	/**
	 * 種別を返す。
	 * 
	 * @return	種別
	 */
	public int getKind()
	{
		return kind;
	}

	/**
	 * メッセージを返す。
	 * 
	 * @return	メッセージ
	 */
	public String getMessage()
	{
		return message;
	}
}
