/* $Id: FileManager.java,v 1.1 2007/10/19 08:19:34 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.wfmc.x2002.xpdl10.PackageDocument;

/**
 * ジョブデザイナで使用するファイルの入出力管理を行う。
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class FileManager
{
	/** 保存用空XPDL */
	private static final String EMPTY_FLOW
		= "/jp/co/argo21/nautica/tool/wfd/resources/empty.xpdl";

	/** 初期化用XPDL */
	private static final String INITIAL_FLOW
		= "/jp/co/argo21/nautica/tool/wfd/resources/initial.xpdl";

	/** ワークフロー定義XPDLファイル名 */
	private String filename;
	
	/** ワークフロー定義ドキュメント */
	private PackageDocument document;
	
	/**
	 * ワークフロー定義XPDLファイル名を返す。
	 * 
	 * @return ワークフロー定義XPDLファイル名
	 */
	public String getFilename()
	{
		return filename;
	}
	
	/**
	 * ワークフロー定義ドキュメントを返す。
	 * 
	 * @return ワークフロー定義ドキュメント
	 */
	public PackageDocument getDocument()
	{
		return document;
	}
	
	/**
	 * ワークフロー定義ドキュメントを設定する。
	 * 
	 * @param doc ワークフロー定義ドキュメント
	 */
	public void setDocument(PackageDocument doc)
	{
		document = doc;
	}
	
	/**
	 * 空のワークフロー定義ドキュメントを返す。
	 * 
	 * @throws XmlException XML例外
	 * @throws IOException 入出力例外
	 * @return ワークフロー定義ドキュメント
	 */
	public PackageDocument getEmptyDocument() throws XmlException, IOException
	{
		InputStream in = getClass().getResourceAsStream(EMPTY_FLOW);
		XmlOptions opts = new XmlOptions();
		opts.setCharacterEncoding("utf-8");
		PackageDocument doc = PackageDocument.Factory.parse(in, opts);
		in.close();
		return doc;
	}
	
	/**
	 * ワークフロー定義ドキュメントを初期化する。
	 * 
	 * @throws XmlException XML例外
	 * @throws IOException 入出力例外
	 */
	public void initDocument() throws XmlException, IOException
	{
		filename = null;
		InputStream in = getClass().getResourceAsStream(INITIAL_FLOW);
		XmlOptions opts = new XmlOptions();
		opts.setCharacterEncoding("utf-8");
		document = PackageDocument.Factory.parse(in, opts);
		in.close();
	}
	
	/**
	 * ワークフロー定義ドキュメントをロードする。
	 * 
	 * @param fn XPDLファイル名
	 * @throws XmlException XML例外
	 * @throws IOException 入出力例外
	 */
	public void loadDocument(String fn) throws XmlException, IOException
	{
		File f = new File(fn);
		InputStream in = new FileInputStream(f);
		XmlOptions opts = new XmlOptions();
		opts.setCharacterEncoding("utf-8");
		document = PackageDocument.Factory.parse(in, opts);
		in.close();
		filename = fn;
	}
	
	/**
	 * ワークフロー定義ドキュメントをファイルに保存する。
	 * 
	 * @throws XmlException XML例外
	 * @throws IOException 入出力例外
	 */
	public void saveDocument() throws XmlException, IOException
	{
		OutputStream out = new FileOutputStream(filename);
		XmlOptions opts = new XmlOptions();
		opts.setSavePrettyPrint();
		opts.setSavePrettyPrintIndent(2);
		opts.setCharacterEncoding("utf-8");
		document.save(out, opts);
		out.close();
	}
	
	/**
	 * ワークフロー定義ドキュメントをファイルに保存する。
	 * 
	 * @param fn XPDLファイル名
	 * @throws XmlException XML例外
	 * @throws IOException 入出力例外
	 */
	public void saveDocument(String fn) throws XmlException, IOException
	{
		OutputStream out = new FileOutputStream(fn);
		XmlOptions opts = new XmlOptions();
		opts.setSavePrettyPrint();
		opts.setSavePrettyPrintIndent(2);
		opts.setCharacterEncoding("utf-8");
		document.save(out, opts);
		out.close();
		filename = fn;
	}
}
