/* $Id: ElementInspectorManager.java,v 1.1 2007/10/19 08:19:34 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd;

import jp.co.argo21.nautica.tool.wfd.element.ApplicationElement;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.PackageElement;
import jp.co.argo21.nautica.tool.wfd.element.ParameterElement;
import jp.co.argo21.nautica.tool.wfd.element.ParticipantElement;
import jp.co.argo21.nautica.tool.wfd.element.ProcessElement;
import jp.co.argo21.nautica.tool.wfd.element.VariableElement;
import jp.co.argo21.nautica.tool.wfd.inspector.ApplicationInspector;
import jp.co.argo21.nautica.tool.wfd.inspector.PackageInspector;
import jp.co.argo21.nautica.tool.wfd.inspector.ParameterInspector;
import jp.co.argo21.nautica.tool.wfd.inspector.ParticipantInspector;
import jp.co.argo21.nautica.tool.wfd.inspector.ProcessInspector;
import jp.co.argo21.nautica.tool.wfd.inspector.VariableInspector;

/**
 * 各要素用のインスペクタのインスタンスを一括管理するマネージャ。
 * 
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class ElementInspectorManager extends InspectorManager
{
	/**
	 * 要素インスペクタマネージャを生成する。
	 */
	public ElementInspectorManager()
	{
		putInspectorForName(WorkflowDesignerConstants.EL_PACKAGE, new PackageInspector());
		putInspectorForName(WorkflowDesignerConstants.EL_PARTICIPANT, new ParticipantInspector());
		putInspectorForName(WorkflowDesignerConstants.EL_APPLICATION, new ApplicationInspector());
		putInspectorForName(WorkflowDesignerConstants.EL_VARIABLE, new VariableInspector());
		putInspectorForName(WorkflowDesignerConstants.EL_PROCESS, new ProcessInspector());
		putInspectorForName(WorkflowDesignerConstants.EL_PARAMETER, new ParameterInspector());
	}

	/**
	 * 要素に対応するインスペクタを返す。
	 * 
	 * @param elem	要素
	 * @return	インスペクタ
	 */	
	public static String getInspectorKey(Element elem)
	{
		if (elem instanceof PackageElement) {
			return WorkflowDesignerConstants.EL_PACKAGE;
		} else if (elem instanceof ParticipantElement) {
			return WorkflowDesignerConstants.EL_PARTICIPANT;
		} else if (elem instanceof ApplicationElement) {
			return WorkflowDesignerConstants.EL_APPLICATION;
		} else if (elem instanceof VariableElement) {
			return WorkflowDesignerConstants.EL_VARIABLE;
		} else if (elem instanceof ProcessElement) {
			return WorkflowDesignerConstants.EL_PROCESS;
		} else if (elem instanceof ParameterElement) {
			return WorkflowDesignerConstants.EL_PARAMETER;
		} else {
			return null;
		}
	}
}
