/* $Id: DesignerStatusBar.java,v 1.1 2007/10/19 08:19:34 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd;

import java.awt.BorderLayout;
import java.awt.Dimension;

import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

/**
 * ステータスバーを実現する。
 *
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class DesignerStatusBar extends JPanel
{
	/** シリアルバージョンID */
	private static final long serialVersionUID = 1L;

	/** 表示用ラベル。 */
	private JLabel message = new JLabel();

	/**
	 * ステータスバーを生成する。
	 */
	public DesignerStatusBar()
	{
		Dimension size = new Dimension(20, 20);
		message.setPreferredSize(size);

		BorderLayout layout = new BorderLayout();
		this.setLayout(layout);
		this.setBorder(BorderFactory.createLoweredBevelBorder());

		/* ラベルをステータスバーに追加 */
		this.add(message, BorderLayout.CENTER);
	}

	/**
	 * ステータスバーにメッセージを表示する。
	 * 
	 * @param s メッセージ
	 */
	void setMessage(String s)
	{
		if (s != null) {
			message.setText(s);
		} else {
			clearMessage();
		}
	}

	/**
	 * ステータスバー上のメッセージをクリアする。
	 */
	void clearMessage()
	{
		message.setText("");
	}
}
