/* $Id: ConditionDialog.java,v 1.1 2007/10/19 08:19:34 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import jp.co.argo21.nautica.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.expression.Expression;

/**
 * 条件表示用のダイアログを提供する。
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class ConditionDialog extends JDialog
{
	/** シリアルバージョンID */
	private static final long serialVersionUID = 1L;

	/** 条件表示用のビュー */
	private ConditionEditorView view;

	/**
	 * 条件表示用ダイアログを表示する。
	 * 
	 * @param c	親コンポーネント
	 * @param exp	条件式
	 * @return	更新された条件式
	 */
	public static Expression showDialog(Component c, Expression exp)
	{
		Frame frame = JOptionPane.getFrameForComponent(c);
		ConditionDialog dialog = new ConditionDialog(frame, exp);
		dialog.setVisible(true);
		Expression result = dialog.view.getExpression();
		dialog.dispose();
		return result;
	}

	/**
	 * 条件表示用ダイアログを生成する。
	 * 
	 * @param frame	親フレーム
	 * @param exp	条件式
	 */
	private ConditionDialog(Frame frame, Expression exp)
	{
		super(frame, true);
		
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();

		setTitle(rm.getResource("ConditionDialog.title"));
		
		view = new ConditionEditorView();
		view.setExpression(exp);

		JScrollPane scroll = new JScrollPane();
		scroll.setViewportView(view);

		JPanel buttonPane = new JPanel();
		buttonPane.setLayout(new FlowLayout(FlowLayout.RIGHT, 10, 10));

		ActionListener listener = new CloseAction();
		JButton setButton = new JButton(rm.getResource("JButton.label.set"));
		setButton.setActionCommand("OK_OPTION");
		setButton.addActionListener(listener);
		getRootPane().setDefaultButton(setButton);
		buttonPane.add(setButton);

		JButton cancelButton = new JButton(rm.getResource("JButton.label.cancel"));
		cancelButton.addActionListener(listener);
		buttonPane.add(cancelButton);

		Container contentPane = getContentPane();
		contentPane.add(scroll, BorderLayout.CENTER);
		contentPane.add(buttonPane, BorderLayout.PAGE_END);

		pack();

		setLocationRelativeTo(frame);
	}

	/**
	 * ボタンが押されたときの処理
	 */
	private class CloseAction implements ActionListener
	{
		/**
		 * 確認を行い、問題なければ閉じる。
		 * 
		 * @param e	イベント
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			if ("OK_OPTION".equals(e.getActionCommand())) {
				if (view.check() == false) {
					//エラーがあったので、コミットせずにreturn
					//ダイアログは閉じない
					return;
				}
				view.commit();
			}
			setVisible(false);
		}
	}
}
