/* $Id: WorkflowServiceManager.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.wfmc;

/**
 * ワークフローサービスマネージャはは、ワークフローエンジンに対する
 * 総合クライアントインタフェースである。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public interface WorkflowServiceManager {

	/**
	 * ワークフローエンジンへの接続認証を行い、
	 * セッションIDを取得する。
	 *
	 * @param user ユーザID
	 * @param pass パスワード
	 * @return セッションID
	 * @throws ConnectionFailedException 接続認証に失敗した場合
	 */
	public String connect(String user, String pass)
	throws ConnectionFailedException;

	/**
	 * ワークフローエンジンとの切断を行う。
	 *
	 * @param session セッションID
	 * @throws InvalidSessionException 指定されたセッションが無効の場合
	 */
	public void disconnect(String session)
	throws InvalidSessionException;

	/**
	 * 定義リポジトリを返す。
	 *
	 * @param session セッションID
	 * @return 定義リポジトリ
	 * @throws InvalidSessionException 指定されたセッションが無効の場合
	 */
	public DefinitionRepository getDefinitionRepository(String session)
	throws InvalidSessionException;

	/**
	 * 作業項目ハンドラを返す。
	 *
	 * @param session セッションID
	 * @return 作業項目ハンドラ
	 * @throws InvalidSessionException 指定されたセッションが無効の場合
	 */
	public WorkItemHandler getWorkItemHandler(String session)
	throws InvalidSessionException;

	/**
	 * ワークフローエンジンハンドラを返す。
	 *
	 * @param session セッションID
	 * @return ワークフローエンジンハンドラ
	 * @throws InvalidSessionException 指定されたセッションが無効の場合
	 */
	public WorkflowEngineHandler getWorkflowEngineHandler(String session)
	throws InvalidSessionException;

	/**
	 * ワークフロー管理ハンドラを返す。
	 *
	 * @param session セッションID
	 * @return ワークフロー管理ハンドラ
	 * @throws InvalidSessionException 指定されたセッションが無効の場合
	 */
	public WorkflowAdminHandler getWorkflowAdminHandler(String session)
	throws InvalidSessionException;
}
