/* $Id: WorkflowAdminHandler.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.wfmc;

/**
 * ワークフロー管理ハンドラは、ワークフローに対する
 * 管理クライアントインタフェースである。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public interface WorkflowAdminHandler {

	/**
	 * 指定されたプロセス定義に属するプロセスインスタンスを
	 * フィルターで絞り込み、状態の変更を行う。
	 * 指定可能なフィルターはStateFilterとする。
	 *
	 * @param session セッションID
	 * @param pdid プロセス定義ID
	 * @param filter 検索用フィルター
	 * @param state 新しいプロセスインスタンス状態
	 * @throws InvalidSessionException 指定されたセッションが無効の場合
	 * @throws InvalidProcessDefinitionException 指定されたプロセス定義IDが有効でない場合
	 * @throws InvalidFilterException 指定されたフィルターが有効でない場合
	 * @throws InvalidStateException 指定された状態が有効でない場合
	 * @throws TransitionNotAllowedException 状態の変更が許可されていない場合
	 */
	public void changeProcessesState(String session,
			String pdid, Filter filter, ProcessState state)
	throws InvalidSessionException, InvalidProcessDefinitionException,
	InvalidFilterException, InvalidStateException,
	TransitionNotAllowedException;

	/**
	 * 指定されたプロセス定義とアクティビティ定義に属する
	 * アクティビティインスタンスをフィルターで絞り込み、状態の変更を行う。
	 * 指定可能なフィルターはStateFilterとする。
	 *
	 * @param session セッションID
	 * @param pdid プロセス定義ID
	 * @param adid アクティビティ定義ID
	 * @param filter 検索用フィルター
	 * @param state 新しいアクティビティインスタンス状態
	 * @throws InvalidSessionException 指定されたセッションが無効の場合
	 * @throws InvalidProcessDefinitionException 指定されたプロセス定義IDが有効でない場合
	 * @throws InvalidActivityNameException 指定されたアクティビティ定義IDが有効でない場合
	 * @throws InvalidFilterException 指定されたフィルターが有効でない場合
	 * @throws InvalidStateException 指定された状態が有効でない場合
	 * @throws TransitionNotAllowedException 状態の変更が許可されていない場合
	 */
	public void changeActivitiesState(String session,
			String pdid, String adid, Filter filter, ActivityState state)
	throws InvalidSessionException, InvalidProcessDefinitionException,
	InvalidActivityNameException, InvalidFilterException,
	InvalidStateException, TransitionNotAllowedException;

	/**
	 * 指定されたプロセス定義に属するプロセスインスタンスを
	 * フィルターで絞り込み、停止を行う。
	 *
	 * @param session セッションID
	 * @param pdid プロセス定義ID
	 * @param filter 検索用フィルター
	 * @throws InvalidSessionException 指定されたセッションが無効の場合
	 * @throws InvalidProcessDefinitionException 指定されたプロセス定義IDが有効でない場合
	 * @throws InvalidFilterException 指定されたフィルターが有効でない場合
	 */
	public void terminateProcesses(String session,
			String pdid, Filter filter)
	throws InvalidSessionException, InvalidProcessDefinitionException,
		InvalidFilterException;

	/**
	 * 指定されたプロセス定義に属するプロセスインスタンスを
	 * フィルターで絞り込み、属性の割り当てを行う。
	 *
	 * @param session セッションID
	 * @param pdid プロセス定義ID
	 * @param filter 検索用フィルター
	 * @param attr 属性
	 * @throws InvalidSessionException 指定されたセッションが無効の場合
	 * @throws InvalidProcessDefinitionException 指定されたプロセス定義IDが有効でない場合
	 * @throws InvalidFilterException 指定されたフィルターが有効でない場合
	 * @throws InvalidAttributeException 属性が有効でない場合
	 */
	public void assignProcessesAttribute(String session,
			String pdid, Filter filter, Attribute attr)
	throws InvalidSessionException, InvalidProcessDefinitionException,
		InvalidFilterException, InvalidAttributeException;

	/**
	 * 指定されたプロセス定義とアクティビティ定義に属する
	 * アクティビティインスタンスをフィルターで絞り込み、
	 * 属性の割り当てを行う。
	 *
	 * @param session セッションID
	 * @param pdid プロセス定義ID
	 * @param adid アクティビティ定義ID
	 * @param filter 検索用フィルター
	 * @param attr 属性
	 * @throws InvalidSessionException 指定されたセッションが無効の場合
	 * @throws InvalidProcessDefinitionException 指定されたプロセス定義IDが有効でない場合
	 * @throws InvalidActivityNameException 指定されたアクティビティ定義IDが有効でない場合
	 * @throws InvalidFilterException 指定されたフィルターが有効でない場合
	 * @throws InvalidAttributeException 属性が有効でない場合
	 */
	public void assignActivitiesAttribute(String session,
			String pdid, String adid, Filter filter, Attribute attr)
	throws InvalidSessionException, InvalidProcessDefinitionException,
		InvalidActivityNameException, InvalidFilterException,
		InvalidAttributeException;

	/**
	 * 指定されたプロセス定義に属するプロセスインスタンスを
	 * フィルターで絞り込み、中断を行う。
	 *
	 * @param session セッションID
	 * @param pdid プロセス定義ID
	 * @param filter 検索用フィルター
	 * @throws InvalidSessionException 指定されたセッションが無効の場合
	 * @throws InvalidProcessDefinitionException 指定されたプロセス定義IDが有効でない場合
	 * @throws InvalidFilterException 指定されたフィルターが有効でない場合
	 */
	public void abortProcesses(String session,
			String pdid, Filter filter)
	throws InvalidSessionException, InvalidProcessDefinitionException,
		InvalidFilterException;

	/**
	 * 指定されたプロセスインスタンスの中断を行う。
	 *
	 * @param session セッションID
	 * @param pid プロセスインスタンスID
	 * @throws InvalidSessionException 指定されたセッションが無効の場合
	 * @throws InvalidProcessInstanceException プロセスインスタンスIDが有効でない場合
	 */
	public void abortProcess(String session, String pid)
	throws InvalidSessionException, InvalidProcessInstanceException;
}
