/* $Id: Participant.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.wfmc;

import jp.co.argo21.nautica.workflow.definition.ParticipantDefinition;
import jp.co.argo21.nautica.workflow.omg.WfObject;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;

/**
 * ワークフロー参加者を表す。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public interface Participant extends WfObject
{
	/** 人 */
	public static final int HUMAN               = ParticipantDefinition.HUMAN;
	/** 組織単位 */
	public static final int ORGANIZATIONAL_UNIT = ParticipantDefinition.ORGANIZATIONAL_UNIT;
	/** ロール */
	public static final int ROLE                = ParticipantDefinition.ROLE;
	/** システム */
	public static final int SYSTEM              = ParticipantDefinition.SYSTEM;

	/**
	 * 参加者IDを返す。
	 *
	 * @return ID
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public String getID() throws WorkflowException;

	/**
	 * 参加者名称を返す
	 *
	 * @return 名称
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public String getName() throws WorkflowException;

	/**
	 * 参加者型を返す。
	 * 
	 * @return	参加者型
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public int getType() throws WorkflowException;

	/**
	 * 保持する属性を返す。
	 *
	 * @param name 属性名
	 * @return 属性値
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public String getAttribute(String name)
	throws WorkflowException;

	/**
	 * 属性を設定する。
	 *
	 * @param name 属性名
	 * @param value 属性値
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public void setAttribute(String name, String value)
	throws WorkflowException;

	/**
	 * 保持するすべての属性名を返す。
	 *
	 * @return 属性名の一覧
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public String[] getAllAttributeNames()
	throws WorkflowException;
}
