/* $Id: FormalParameter.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.wfmc;

import jp.co.argo21.nautica.workflow.omg.WfNameValue;

/**
 * 形式パラメータを表すインタフェース。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public interface FormalParameter extends WfNameValue
{
	/**
	 * IDを返す。
	 *
	 * @return ID
	 */
	public String getID();

	/**
	 * パラメータ名を返す。
	 *
	 * @return パラメータ名
	 * @see jp.co.argo21.nautica.workflow.omg.WfNameValue#getName()
	 */
	public String getName();

	/**
	 * パラメータ値を返す。
	 *
	 * @return パラメータ値
	 * @see jp.co.argo21.nautica.workflow.omg.WfNameValue#getValue()
	 */
	public String getValue();

	/**
	 * パラメータの型を返す。
	 *
	 * @return パラメータの型
	 */
	public int getType();

	/**
	 * 入出力モードを返す。
	 *
	 * @return 入出力モード
	 */
	public int getMode();

	/**
	 * 備考を返す。
	 *
	 * @return 備考
	 */
	public String getDescription();

	/**
	 * IDを設定する。
	 * 
	 * @param id IDへの設定値
	 */
	public void setID(String id);

	/**
	 * パラメータ名を設定する。
	 * 
	 * @param name パラメータ名
	 */
	public void setName(String name);

	/**
	 * パラメータ値を設定する。
	 * 
	 * @param value パラメータ値
	 */
	public void setValue(String value);

	/**
	 * パラメータ型を設定する。
	 * 
	 * @param type パラメータ型
	 */
	public void setType(int type);

	/**
	 * 入出力モードを設定する。
	 * 
	 * @param mode 入出力モード
	 */
	public void setMode(int mode);

	/**
	 * 備考を設定する。
	 * 
	 * @param description 備考
	 */
	public void setDescription(String description);
}
