/* $Id: Filter.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.wfmc;

import jp.co.argo21.nautica.workflow.omg.WfObject;

/**
 * ワークフローAPI上で引数に指定する絞込条件を表すオブジェクトである。
 * 本ワークフローシステム運用基盤では、名前によるフィルタリング、
 * 状態によるフィルタリング、プロセス変数によるフィルタリング、
 * グループフィルタリングをサポートする。
 * なお、グループフィルタリングは、それに含まれるフィルターの
 * 論理積(AND)のみをサポートする。
 * なおフィルター対象を特定する文字列がどのように利用されるかは、
 * フィルターを利用するAPIによって異なる。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public interface Filter extends WfObject
{
	/** = */
	public static final int EQUAL         = 1;
	/** <> */
	public static final int NOT_EQUAL     = 2;
	/** < */
	public static final int LESS_THAN     = 3;
	/** <= */
	public static final int LESS_EQUAL    = 4;
	/** > */
	public static final int GREATER_THAN  = 5;
	/** >= */
	public static final int GREATER_EQUAL = 6;
	/** LIKE */
	public static final int LIKE          = 7;

	/**
	 * フィルターのタイプを表す。
	 * 本ワークフローシステム運用基盤では、名前によるフィルタリング、
	 * 状態によるフィルタリング、プロセス変数によるフィルタリング、
	 * グループフィルタリングをサポートする。
	 * 本ワークフローシステム運用基盤では、フィルタータイプとして、
	 * 5001-5999までの値をリザーブする。
	 * 
	 * @return フィルターのタイプ
	 */
	public int getType();

	/**
	 * フィルター対象を特定する文字列を表す。
	 *
	 * @return フィルター対象を特定する文字列
	 */
	public String getFilterName();

	/**
	 * フィルタリングの演算子を表す。
	 * ==、!=に対応する数値定数。
	 *
	 * @return フィルタリングの演算子
	 */
	public int getComparison();

	/**
	 * フィルタリング文字列。
	 *
	 * @return フィルタリング文字列
	 */
	public String getFilterString();
}
