/* $Id: StateHelper.java,v 1.1 2007/10/29 02:55:37 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.util;

import jp.co.argo21.nautica.workflow.wfmc.ActivityState;
import jp.co.argo21.nautica.workflow.wfmc.ProcessState;
import jp.co.argo21.nautica.workflow.wfmc.WorkItemState;

/**
 * 状態に関するヘルパークラスである。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class StateHelper
{
	/**
	 * プロセス状態をアクティビティ状態に変換する。
	 *
	 * @param state プロセス状態
	 * @return アクティビティ状態
	 */
	public static ActivityState convert(ProcessState state)
	{
		int stateNum = state.toInt();
		return ActivityState.getState(stateNum);
	}

	/**
	 * アクティビティ状態を作業項目状態に変換する。
	 *
	 * @param state アクティビティ状態
	 * @return 作業項目状態
	 */
	public static WorkItemState convert(ActivityState state)
	{
		int stateNum = state.toInt();
		return WorkItemState.getState(stateNum);
	}

	/**
	 * 作業項目状態をアクティビティ状態に変換する。
	 *
	 * @param state 作業項目状態
	 * @return アクティビティ状態
	 */
	public static ActivityState convert(WorkItemState state)
	{
		int stateNum = state.toInt();
		return ActivityState.getState(stateNum);
	}
	
	/**
	 * src状態からdest状態に遷移可能かを返す。
	 *
	 * @param src 遷移元状態
	 * @param dest 遷移先状態
	 * @return 遷移可能ならtrue
	 */
	public static boolean containsTransitable(ProcessState src, ProcessState dest)
	{
		int destStateNum = dest.toInt();
		WorkItemState[] tstates = WorkItemState.getTransitableStates(src.toInt());
		
		for (int i = 0; i < tstates.length; i++) {
			int stateNum = tstates[i].toInt();
			if (stateNum == destStateNum) {
				return true;
			}
		}
		return false;
	}
	
	/**
	 * src状態からdest状態に遷移可能かを返す。
	 *
	 * @param src 遷移元状態
	 * @param dest 遷移先状態
	 * @return 遷移可能ならtrue
	 */
	public static boolean containsTransitable(ActivityState src, ActivityState dest)
	{
		int destStateNum = dest.toInt();
		WorkItemState[] tstates = WorkItemState.getTransitableStates(src.toInt());
		
		for (int i = 0; i < tstates.length; i++) {
			int stateNum = tstates[i].toInt();
			if (stateNum == destStateNum) {
				return true;
			}
		}
		return false;
	}
	
	/**
	 * src状態からdest状態に遷移可能かを返す。
	 *
	 * @param src 遷移元状態
	 * @param dest 遷移先状態
	 * @return 遷移可能ならtrue
	 */
	public static boolean containsTransitable(WorkItemState src, WorkItemState dest)
	{
		int destStateNum = dest.toInt();
		WorkItemState[] tstates = WorkItemState.getTransitableStates(src.toInt());
		
		for (int i = 0; i < tstates.length; i++) {
			int stateNum = tstates[i].toInt();
			if (stateNum == destStateNum) {
				return true;
			}
		}
		return false;
	}
}
