/* $Id: GeronimoUtils.java,v 1.1 2007/10/29 02:55:37 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2007.  All rights reserved.
 */
package jp.co.argo21.nautica.workflow.util;

import java.util.Properties;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.apache.geronimo.connector.outbound.ConnectionFactorySource;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.InternalKernelException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelRegistry;
import org.apache.geronimo.kernel.NoSuchOperationException;

public class GeronimoUtils
{
	static {
		
	}

	public static Object getGBean(String gbeanName)
	throws GBeanNotFoundException, InternalKernelException, IllegalStateException
	{
		Kernel kernel = KernelRegistry.getSingleKernel();
		return kernel.getGBean(gbeanName);
	}

	public static Object getEJB(String providerURL, String ejbName)
	throws NamingException
	{
		Properties env = new Properties();
		env.put(Context.INITIAL_CONTEXT_FACTORY,
				"org.apache.openejb.client.RemoteInitialContextFactory");
		env.put(Context.PROVIDER_URL, providerURL);

		Context ctx = new InitialContext(env);
		return ctx.lookup(ejbName);
	}

	public static Object getConnectionFactory(String resourceName)
	throws GBeanNotFoundException, NoSuchOperationException,
			InternalKernelException, Exception
	{
		Kernel kernel = KernelRegistry.getSingleKernel();
		return kernel.invoke(
				resourceName,
				ConnectionFactorySource.class,
				"$getResource",
				new Object[]{},
				new String[]{}
				);
	}
}
