/* $Id: DurationHelper.java,v 1.1 2007/10/29 02:55:37 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.util;

import jp.co.argo21.nautica.workflow.definition.ProcessDefinition;

/**
 * 期間関連のヘルパークラス。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class DurationHelper
{
	/** 年 */
	public static final long YEAR_VAL   =        1000L;
	/** 月 */
	public static final long MONTH_VAL  =       60000L;
	/** 日 */
	public static final long DAY_VAL    =      360000L;
	/** 時間 */
	public static final long HOUR_VAL   =    86400000L;
	/** 分 */
	public static final long MINUTE_VAL =  2592000000L;
	/** 秒 */
	public static final long SECOND_VAL = 31536000000L;
	
	/**
	 * 期間単位と数値から経過ミリ秒を返す。
	 *
	 * @param unit 期間単位
	 * @param value 数値
	 * @return 経過ミリ秒
	 */
	public static long calculateDuration(int unit, int value)
	{
		long valueUnit = DAY_VAL;
		
		switch (unit) {
		case ProcessDefinition.SECOND:
			valueUnit = SECOND_VAL;
			break;
		case ProcessDefinition.MINUTE:
			valueUnit = MINUTE_VAL;
			break;
		case ProcessDefinition.HOUR:
			valueUnit = HOUR_VAL;
			break;
		case ProcessDefinition.MONTH:
			valueUnit = MONTH_VAL;
			break;
		case ProcessDefinition.YEAR:
			valueUnit = YEAR_VAL;
			break;
		}
		return (valueUnit * value);
	}
}
