/* $Id: SystemCommandExecutionInfo.java,v 1.2 2007/11/13 06:58:25 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.ta;

import java.io.Serializable;
import java.util.HashMap;

import jp.co.argo21.nautica.workflow.wfmc.Attribute;

/**
 * システムコマンドツールエージェント用のアプリケーション実行情報クラス
 * 
 * @author kiyoda(Argo 21, Corp.)
 * @version $Revision: 1.2 $
 * @since Nautica Workflow 1.0
 */
public class SystemCommandExecutionInfo extends AppExecutionInfo
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/* システムコマンド用実行情報のメッセージタイプ */
	private static final int MESSAGE_TYPE = 801;

	/**
	 * 引数付コンストラクタ
	 * 
	 * @param appName
	 *            アプリケーション名
	 * @param toolAgent
	 *            ツールエージェントのクラス名
	 * @param wid
	 *            作業項目ID
	 * @param handler
	 *            ツールエージェントハンドラ（＝作業項目ID）
	 * @param attrList
	 *            引数リスト
	 */
	SystemCommandExecutionInfo(String appName, String toolAgent, String wid,
			int handler, Attribute[] attrList)
	{
		super(MESSAGE_TYPE);
		this.setAppName(appName);
		this.setToolAgent(toolAgent);
		this.setWid(wid);
		this.setHandler(handler);
		this.setAttributes(attrList);
	}

	SystemCommandExecutionInfo(HashMap<String, Serializable> map)
	{
		super(map);
	}
}
