/* $Id: SystemCommandConfig.java,v 1.1 2007/10/29 02:55:37 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.ta;

import java.util.HashMap;
import java.util.Map;

import jp.co.argo21.nautica.workflow.ta.config.App;
import jp.co.argo21.nautica.workflow.ta.config.SystemCommand;
import jp.co.argo21.nautica.workflow.ta.config.SystemCommandsDocument.SystemCommands;

/**
 * システムコマンド実行用設定オブジェクト
 *
 * @author  kiyoda(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class SystemCommandConfig {

    /**
     * ユーザID
     */
    private String user = null;
    
    /**
     * パスワード
     */
    private String password = null;
    
    /**
     * アプリケーションとコマンド文字列の対応表
     */
    private Map<String, String> applications = new HashMap<String, String>();
    
    /**
     * 引数付コンストラクタ
     *
     * @param systemCommands SystemCommandsオブジェクト
     */
    SystemCommandConfig(SystemCommands systemCommands) {
        // ツールエージェント個々の認証情報の設定
        this.user = systemCommands.getAuthentication().getUser();
        this.password = systemCommands.getAuthentication().getPassword();
        
        // アプリケーション名とコマンド文字列のマッピングの設定
        SystemCommand[] commands = systemCommands.getSystemCommandArray();
        for (int i = 0; i < commands.length; i++) {
            String command = commands[i].getCommand();
            App[] apps = commands[i].getAppArray();
            for (int j = 0; j < apps.length; j++) {
                this.applications.put(apps[j].getName(), command);
            }
        }
    }
    
    /**
     * アプリケーション名に対応したコマンド文字列を取得
     *
     * @param appName　アプリケーション名
     * @return	コマンド文字列
     */
    public String getCommandString(String appName)
    {
        return (String)this.applications.get(appName);
    }
    
    /**
     * パラメータのアプリケーション名が設定情報に存在するかどうかチェック
     *
     * @param appName　アプリケーション名
     * @return	設定情報に指定したアプリケーションが存在する場合、true
     */
    public boolean existApplication(String appName)
    {
        return this.applications.containsKey(appName);
    }
    
    /**
     * ユーザIDを取得する
     *
     * @return	ユーザID
     */
    public String getUser() {
        return this.user;
    }
    
    /**
     * パスワードを取得する
     *
     * @return	パスワード
     */
    public String getPassword() {
        return this.password;
    }
}
