/* $Id: ScriptingConfigFactory.java,v 1.1 2007/10/29 02:55:37 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.ta;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;

import jp.co.argo21.nautica.workflow.engine.SystemChecker;
import jp.co.argo21.nautica.workflow.engine.WorkflowEngineConstants;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.ta.config.ScriptingDocument;
import jp.co.argo21.nautica.workflow.ta.config.ScriptingDocument.Scripting;
import jp.co.argo21.nautica.workflow.util.StringManager;

import org.apache.xmlbeans.XmlOptions;

/**
 * スクリプト実行用設定オブジェクトのファクトリクラス
 *
 * @author  kiyoda(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class ScriptingConfigFactory {
    
    /**
     * 設定ファイル名
     */
    public static String CONFIG_FILENAME = "scriptingconfig.xml";

    /**
     * 設定ファイルの最終更新日時
     */
    private static long lastModified = 0; 
    
    /**
     * 設定情報オブジェクトのシングルトン
     */
    private static ScriptingConfig config = null;
    
    /**
     * デフォルトコンストラクタ
     */
    private ScriptingConfigFactory() {
        super();
    }
    
    /**
     * スクリプト実行用設定オブジェクトを取得する
     *
     * @return	スクリプト実行用設定オブジェクト
     * @throws WorkflowException
     */
    public static synchronized ScriptingConfig getConfig() throws WorkflowException {
        
        try {
            File configFile = new File(getConfigPath());
            if (config == null || lastModified < configFile.lastModified()) {
            	InputStream in = new FileInputStream(configFile);
            	XmlOptions opts = new XmlOptions();
            	opts.setCharacterEncoding("utf-8");
            	ScriptingDocument doc = 
                	ScriptingDocument.Factory.parse(in, opts);
            	Scripting scripting = doc.getScripting();
            	
            	// 設定オブジェクト作成
            	config = new ScriptingConfig(scripting);
            	// 設定ファイルの最終更新日時を更新
            	lastModified = configFile.lastModified();
            }
        } catch (Exception ex) {
            // エラー処理
            String errMsg = StringManager.get("E2005");
            throw new WorkflowException(errMsg, ex);
        }
        return config;
    }

    /**
     * 設定ファイルのパスを取得する
     *
     * @return	設定ファイルのパス
     * @throws WorkflowException
     */
	private static URI getConfigPath()	throws WorkflowException {
	    
		String home = SystemChecker.getProperty(WorkflowEngineConstants.NAUTICA_HOME);
		String conf = CONFIG_FILENAME;
		String separator = SystemChecker.getProperty("file.separator");
		String path = home
		                   + separator + "config"
						   + separator + conf;
		File confFile = new File(path);
	
		if (! confFile.exists()) {
			throw new WorkflowException(path + " is not found.");
		}
		if (! confFile.isFile()) {
			throw new WorkflowException(path + " is not file.");
		}
		
		return confFile.toURI();
	}

}
