/* $Id: ApplicationState.java,v 1.1 2007/10/29 02:55:37 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.ta;

import jp.co.argo21.nautica.workflow.omg.WfState;

/**
 * アプリケーションの状態を表すオブジェクトである。
 *
 * @author  kiyoda(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public final class ApplicationState implements WfState {

    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

    /** 正常終了(0：completed) */
	public static final ApplicationState COMPLETED
		= new ApplicationState("completed", 0);

	/** 異常終了(1：terminated) */
	public static final ApplicationState TERMINATED
		= new ApplicationState("terminated", 1);

	/** 未開始(2：not_started) */
	public static final ApplicationState NOT_STARTED
		= new ApplicationState("not_started", 2);

	/** 停止中(3：suspended) */
	public static final ApplicationState SUSPENDED
		= new ApplicationState("suspended", 3);

	/** 実行中(6：running) */
	public static final ApplicationState RUNNING
		= new ApplicationState("running", 6);

	/** 識別不可(9：unknown) */
	public static final ApplicationState UNKNOWN
		= new ApplicationState("unknown", 9);
	
	/** 状態文字列 */
	private String stateString;
	
	/** 状態値 */
	private int stateNum;
	
	/**
	 * アプリケーションの状態を返す
	 *
	 * @param i		アプリケーションの状態の数値表現。
	 * 				該当する状態がない場合は、ApplicationState.UNKNOWNが返る。
	 * @return	アプリケーションの状態
	 */
	public static ApplicationState toApplicationState(int i) {
	    ApplicationState state = null;
	    switch(i) {
	    case 0:
	        state = COMPLETED;
	        break;
	    case 1:
	        state = TERMINATED;
	        break;
	    case 2:
	        state = NOT_STARTED;
	        break;
	    case 3:
	        state = SUSPENDED;
	        break;
	    case 6:
	        state = RUNNING;
	        break;
	    case 9:
	    default:
	        state = UNKNOWN;
	        break;
	    }
	    return state;
	}
	
	/**
	 * アプリケーションの状態を生成する。
	 * 
	 * @param s 状態文字列
	 * @param i 状態値
	 */
	private ApplicationState(String s, int i)
	{
		stateString = s;
		stateNum = i;
	}

	/**
	 * 状態の文字列表現を返す。
	 * 
	 * @return 状態の文字列表現
	 */
	public String toString()
	{
		return stateString;
	}

	/**
	 * 状態の数値表現を返す。
	 * 
	 * @return 状態の数値表現
	 */
	public int toInt()
	{
		return stateNum;
	}
}
