/* $Id: SimpleUserManager.java,v 1.1 2007/10/29 02:55:37 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.security.simple;

import jp.co.argo21.nautica.workflow.dataaccess.UserManagerDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.security.User;
import jp.co.argo21.nautica.workflow.security.UserManager;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.WorkflowSecurityException;

import org.apache.log4j.Logger;

/**
 * 本ワークフローシステム運用基盤及び外部から利用されるユーザ管理関連の
 * 各種APIを提供する参考実装である。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class SimpleUserManager implements UserManager {

	private static Logger sLog = LogManager.getSercurityLogger(); 
	
	/**
	 * SimpleUserManager を生成する。
	 * 
	 * @throws Exception ユーザ管理の公開に失敗した場合
	 */
	public SimpleUserManager() throws Exception {
		try {
			sLog.info(StringManager.get("I1005"));
		} catch (Exception ex) {
			// ユーザ管理の公開に失敗しました。
			String errMsg = StringManager.get("E1008");
			sLog.error(errMsg, ex);
			throw ex;
		}
	}
	
	/**
	 * uidに対応するユーザを返す。
	 * uidに対応するユーザが存在しない場合は null を返す。
	 *
	 * @param  uid ユーザID
	 * @return ユーザ
	 * @throws WorkflowSecurityException その他のセキュリティ例外
	 */
	public User getUser(String uid) throws WorkflowSecurityException {
		
	    try {	        
	        WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
	        UserManagerDAO usermanagerDAO = daoFactory.getUserManagerDAO();
	        
	        User user = usermanagerDAO.findByUserID(uid);
	        return user;
	        
	    } catch (Exception e) {
	        // ユーザの取得に失敗しました。
	        String errMsg = StringManager.get("E1010") + "(UserID = " + uid + ")";
	        sLog.error(errMsg);
	        throw new WorkflowSecurityException(errMsg , e);
	    }
	}
}
