/* $Id: SimplePassswordEncoder.java,v 1.1 2007/12/07 05:04:57 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2007.  All rights reserved.
 */
package jp.co.argo21.nautica.workflow.security.simple;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import jp.co.argo21.nautica.workflow.util.Base64Encoder;

/**
 * Nautica Workflow用パスワードエンコーダ。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class SimplePassswordEncoder
{
	/**
	 * 引数に渡された情報から、エンコード済み文字列を生成して返す。
	 * アルゴリズムはSHAまたはMD5を利用する。(Sun JDKでは標準提供。他社製は要確認。)
	 * 
	 * <ul>
	 * <li>[Security provider] SUN</li>
	 * <li>[Algorithm] SHA</li>
	 * <li>[Algorithm] MD5</li>
	 * </ul>
	 *
	 * @param uid ユーザID
	 * @param passwd パスワード
	 * @return エンコード済み文字列
	 */
	static String encode(String uid, String passwd)
	{
		MessageDigest md = null;
		try {
			md = MessageDigest.getInstance("SHA");
		} catch (NoSuchAlgorithmException ex) {
			try {
				md = MessageDigest.getInstance("MD5");
			} catch (NoSuchAlgorithmException ex2) {
			}
		}

		if (md != null) {
			md.update(uid.getBytes());
			md.update(passwd.getBytes());
			byte[] digest = md.digest();
			return Base64Encoder.encode(digest);
		} else {
			return Base64Encoder.encode((uid + passwd).getBytes());
		}
	}
}
