/* $Id: InvalidOrganizationException.java,v 1.1 2007/10/29 02:55:36 nito Exp $
*
* Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
*/
package jp.co.argo21.nautica.workflow.security;

import jp.co.argo21.nautica.workflow.wfmc.WorkflowSecurityException;

/**
 * 組織が有効でないことが認識された場合に通知する例外である。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class InvalidOrganizationException
extends WorkflowSecurityException {

    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * メッセージを指定して、例外を生成する。
	 * 
	 * @param message メッセージ
	 */
	public InvalidOrganizationException(String message) {
    	super(message);
    }

	/**
	 * メッセージとThrowableを指定して、例外を生成する。
	 * 
	 * @param message メッセージ
	 * @param cause 原因となった例外
	 */
	public InvalidOrganizationException(String message, Throwable cause) {
    	super(message, cause);
    }
}
