/* $Id: WfProcessManager.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.omg;

/**
 * WfProcessManagerは、特定のワークフロープロセスのテンプレートを
 * 表すインタフェースである。
 * OMG仕様ではWfProcessMgrとしているが、WfProcessManagerとした。
 * 本書では、この管理実体を「プロセスマネージャ」と表記する。
 * WfProcessManagerは、WfProcessインスタンスのファクトリである。
 * プロセスマネージャは、プロセスが必要とする情報や、
 * プロセス定義情報などに対するアクセスを提供する。
 * プロセスマネージャは、プロセス定義のラッパーオブジェクトとして機能する。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public interface WfProcessManager extends WfObject
{
	/**
	 * 管理しているプロセスの個数を返す。
	 *
	 * @return プロセスの個数
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public int getProcessCount() throws WorkflowException;

	/**
	 * IDで指定されたプロセスを返す。
	 *
	 * @param pid プロセスID
	 * @return プロセス
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public WfProcess getProcess(String pid) throws WorkflowException;

	/**
	 * 管理下のすべてのプロセスを返す。
	 *
	 * @return プロセス
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public WfProcess[] getAllProcesses() throws WorkflowException;
	
	/**
	 * 引数で指定されたプロセスが、管理下にあるかどうかを返す。
	 *
	 * @param member プロセスID
	 * @return 管理下にある場合は、True
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public boolean isMemberOfProcess(String member)
	throws WorkflowException;

	/**
	 * カテゴリーを返す。
	 *
	 * @return カテゴリ
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public String getCategory() throws WorkflowException;

	/**
	 * 名称を返す。
	 *
	 * @return 名称
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public String getName() throws WorkflowException;

	/**
	 * バージョンを返す。
	 *
	 * @return バージョン
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public String getVersion() throws WorkflowException;

	/**
	 * 詳細情報を返す。
	 *
	 * @return 詳細情報
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public String getDescription() throws WorkflowException;

	/**
	 * 状態を返す。新規のプロセス生成の可否を返す。
	 *
	 * @return 状態
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public WfState getState() throws WorkflowException;

	/**
	 * 状態を設定する。
	 *
	 * @param state 状態 
	 * @throws TransitionNotAllowedException 状態が変更できない場合 
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public void setState(WfState state)
	throws TransitionNotAllowedException, WorkflowException;

	/**
	 * インスタンスのコンテキストの設定方法を定義するメタ情報を返す。
	 *
	 * @return メタ情報
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public WfNameValue[] getContextSignature() throws WorkflowException;
	
	/**
	 * インスタンスが結果を返す方法を指定するメタ情報を返す。
	 *
	 * @return メタ情報
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public WfNameValue[] getResultSignature() throws WorkflowException;

	/**
	 * プロセスのインスタンスを生成し、リクエスタに結合する。
	 * プロセスが生成されると、not_running.not_startedの状態に設定される。
	 *
	 * @param requester プロセスリクエスタ
	 * @param name 人が識別可能なプロセス名
	 * @return 生成されたプロセス
	 * @throws NotEnabledException プロセス生成ができない場合
	 * @throws InvalidRequesterException リクエスタが正しくない場合
	 * @throws RequesterRequiredException リクエスタが指定されていない場合
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public WfProcess createProcess(WfRequester requester, String name)
	throws NotEnabledException, InvalidRequesterException,
		RequesterRequiredException, WorkflowException;
}
