/* $Id: WorkflowMessageAdapter.java,v 1.3 2007/11/28 07:09:06 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.jms;

import java.io.Serializable;
import java.util.HashMap;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.util.StringManager;

/**
 * WorkflowMessageを処理する抽象アダプタオブジェクトである。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 1.0
 */
public abstract class WorkflowMessageAdapter implements MessageListener
{
	/** エンジンログ */
	private static Logger eLog = LogManager.getEngineLogger();
	
	/**
	 * アダプタオブジェクトを生成する。
	 *
	 */
	public WorkflowMessageAdapter() {
	    // 処理なし。
	}
	
	/**
	 * 本来のリスナーインタフェースは内部的に使用される。
	 *
	 * @param message メッセージ
	 * @see javax.jms.MessageListener#onMessage(javax.jms.Message)
	 */
	@SuppressWarnings("unchecked")
	public final void onMessage(Message message)
	{
		if (message instanceof ObjectMessage) {
			try {
				Serializable s = ((ObjectMessage)message).getObject();
				String mid = message.getJMSMessageID();
				boolean isRedelivered = message.getJMSRedelivered();
				if (s instanceof HashMap) {
					WorkflowMessage wfmsg = getMessage((HashMap<String, Serializable>)s);
					onMessage(mid, wfmsg, isRedelivered);
				}
			} catch (JMSException ex) {
				// メッセージ処理中のエラーが起こりました。
				String errMsg = StringManager.get("E0040");
				eLog.error(errMsg, ex);
				throw new RuntimeException(errMsg, ex);
			} catch (Exception ex) {
				// メッセージ処理中のエラーが起こりました。
				String errMsg = StringManager.get("E0040");
				eLog.error(errMsg, ex);
				throw new RuntimeException(errMsg, ex);
			}
		}
	}

	protected abstract WorkflowMessage getMessage(HashMap<String, Serializable> map);
	
	/**
	 * ワークフローメッセージを処理する場合は、本メソッドを
	 * 実装すること。
	 *
	 * @param mid メッセージID
	 * @param message メッセージ
	 * @param isRedelivered 再配信フラグ
	 */
	public abstract void onMessage(String mid, WorkflowMessage message, boolean isRedelivered);
}
