/* $Id: WorkflowMessage.java,v 1.2 2007/11/13 06:58:25 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.jms;

import java.io.Serializable;
import java.util.HashMap;

/**
 * WorkflowMQで処理されるメッセージ用の基底インタフェース
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.2 $
 * @since   Nautica Workflow 1.0
 */
public interface WorkflowMessage extends Serializable
{
	/**
	 * メッセージの種類を表す数値を返す。
	 * 1-1000までは、本ワークフロー運用基盤でリザーブするものとする。
	 *
	 * @return メッセージの種類を表す数値
	 */
	public int getMessageType();

	public HashMap<String, Serializable> getMessageMap();
}
