/* $Id: GroupFilter.java,v 1.1 2007/10/29 02:55:37 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.filter;

import jp.co.argo21.nautica.workflow.wfmc.Filter;

/**
 * いくつかのフィルターをまとめるためのフィルターである。
 * まとめる目的であるため、フィルターインタフェースを使用しているが、
 * 各メソッドの戻り値は有効な値ではないので、注意が必要である。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class GroupFilter implements Filter
{
	/** シリアルバージョンUID */
	private static final long serialVersionUID = 20050000000000001L;

	/** フィルタータイプ */
	private static int FILTER_TYPE = 5004;
	
	/** グループ化するフィルター */
	private Filter[] filters;
	
	/**
	 * グループフィルターを生成する。
	 * グループ化するフィルターは基本的にAND演算によって結合する。
	 *
	 * @param filters グループ化するフィルター
	 */
	public GroupFilter(Filter[] filters)
	{
		this.filters = filters;
	}

	/**
	 * 演算子を返す。常にGroupFilter.EQUALが返るが、使用されない。
	 *
	 * @return 演算子
	 * @see jp.co.argo21.nautica.workflow.wfmc.Filter#getComparison()
	 */
	public int getComparison()
	{
		return GroupFilter.EQUAL;
	}

	/**
	 * フィルター名として、クラス名が返るが、使用されない。
	 *
	 * @return フィルター名
	 * @see jp.co.argo21.nautica.workflow.wfmc.Filter#getFilterName()
	 */
	public String getFilterName()
	{
		return GroupFilter.class.getName();
	}

	/**
	 * フィルター文字列として文字列が返るが、使用されない。
	 *
	 * @return フィルター文字列
	 * @see jp.co.argo21.nautica.workflow.wfmc.Filter#getFilterString()
	 */
	public String getFilterString()
	{
		return filters.toString();
	}

	/**
	 * フィルタータイプを返す。
	 *
	 * @return フィルタータイプ
	 * @see jp.co.argo21.nautica.workflow.wfmc.Filter#getType()
	 */
	public int getType()
	{
		return GroupFilter.FILTER_TYPE;
	}

	/**
	 * 保持されているフィルターを返す。
	 *
	 * @return フィルター
	 */
	public Filter[] getChild()
	{
		return filters;
	}
}
