/* $Id: SystemRoleImpl.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.security.SystemRole;

/**
 * システム権限実装クラスである。
 * 内部の互換性のために用意されている。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class SystemRoleImpl implements SystemRole
{
	/** シリアルバージョンUID */
	private static final long serialVersionUID = 20050000000000001L;

	/** リモートエンジン権限ID */
	public static final String REMOTE_ENGINE_ROLE_ID = "REMOTE_ENGINE";
	/** ツールエージェント権限ID */
	public static final String TOOL_AGENT_ROLE_ID    = "TOOL_AGENT";

	/** リモートエンジン権限名 */
	public static final String REMOTE_ENGINE_ROLE_NAME = "REMOTE ENGINE";
	/** ツールエージェント権限名 */
	public static final String TOOL_AGENT_ROLE_NAME    = "TOOL AGENT";

	/** リモートエンジン権限 */
	public static final SystemRole REMOTE_ENGINE_ROLE =
		new SystemRoleImpl(REMOTE_ENGINE_ROLE_ID, REMOTE_ENGINE_ROLE_NAME);

	/** ツールエージェント権限 */
	public static final SystemRole TOOL_AGENT_ROLE =
		new SystemRoleImpl(TOOL_AGENT_ROLE_ID, TOOL_AGENT_ROLE_NAME);

	/** 権限ID */
	private String id;
	/** 権限説明 */
	private String name;
	/** 属性 */
	private Map<String, String> attrs = new Hashtable<String, String>();
	
	/**
	 * システム権限を生成する。
	 *
	 * @param id 権限ID
	 * @param name 権限名
	 */
	private SystemRoleImpl(String id, String name)
	{
		this.id = id;
		this.name = name;
	}

	/**
	 * 保持するすべての権限属性名を返す。
	 *
	 * @return 属性名の一覧
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 * @see jp.co.argo21.nautica.workflow.security.Role#getAllAttributeNames()
	 */
	public String[] getAllAttributeNames() throws WorkflowException
	{
		Set<String> keys = attrs.keySet();
		return (String[])keys.toArray(new String[keys.size()]);
	}

	/**
	 * 保持する権限属性を返す。
	 *
	 * @param name 属性名
	 * @return 属性値
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 * @see jp.co.argo21.nautica.workflow.security.Role#getAttribute(java.lang.String)
	 */
	public String getAttribute(String name) throws WorkflowException
	{
		return (String)attrs.get(name);
	}

	/**
	 * 権限IDを返す。
	 *
	 * @return 権限ID
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 * @see jp.co.argo21.nautica.workflow.security.Role#getID()
	 */
	public String getID() throws WorkflowException
	{
		return id;
	}

	/**
	 * 権限名称を返す。
	 *
	 * @return 権限名称
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 * @see jp.co.argo21.nautica.workflow.security.Role#getName()
	 */
	public String getName() throws WorkflowException
	{
		return name;
	}

	/**
	 * 参加者型を返す。
	 * 
	 * @return	参加者型
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public int getType() throws WorkflowException
	{
		return SYSTEM;
	}

	/**
	 * 権限属性を設定する。
	 *
	 * @param name 属性名
	 * @param value 属性値
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 * @see jp.co.argo21.nautica.workflow.security.Role#setAttribute(java.lang.String, java.lang.String)
	 */
	public void setAttribute(String name, String value)
			throws WorkflowException
	{
		//NOP
	}
}
