/* $Id: StateEventObject.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import jp.co.argo21.nautica.workflow.omg.WfExecutionObject;
import jp.co.argo21.nautica.workflow.omg.WfStateEvent;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;

/**
 * 状態イベントを表す。このクラスは、互換性のために用意されているだけで
 * 現在のエンジンでは使われていない。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class StateEventObject extends WorkflowEventObject
implements WfStateEvent
{
	/** シリアルバージョンUID */
	private static final long serialVersionUID = 20050000000000001L;

	/** 旧状態 */
	private String oldState;
	/** 新状態 */
	private String newState;
	
	/**
	 * 状態イベントを生成する。
	 *
	 * @param type イベントの種類
	 * @param source イベントを引き起こしたWfExecutionObject
	 * @param timestamp イベント発生日時
	 * @param processManagerName プロセスマネージャ名
	 * @param processManagerVersion プロセスマネージャのバージョン
	 * @param processID プロセスID
	 * @param processName プロセス名
	 * @param activityID アクティビティID
	 * @param activityName アクティビティ名
	 * @param oldState 旧状態
	 * @param newState 新状態
	 */
	public StateEventObject(String type, WfExecutionObject source,
			String timestamp, String processManagerName,
			String processManagerVersion, String processID, String processName,
			String activityID, String activityName, String oldState,
			String newState)
	{
		super(type, source, timestamp, processManagerName,
				processManagerVersion, processID, processName, activityID,
				activityName);
		this.oldState = oldState;
		this.newState = newState;
	}

	/**
	 * 旧状態を返す。
	 *
	 * @return 状態
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 * @see jp.co.argo21.nautica.workflow.omg.WfStateEvent#getOldState()
	 */
	public String getOldState() throws WorkflowException
	{
		return oldState;
	}

	/**
	 * 新状態を返す。
	 *
	 * @return 状態
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 * @see jp.co.argo21.nautica.workflow.omg.WfStateEvent#getNewState()
	 */
	public String getNewState() throws WorkflowException
	{
		return newState;
	}

}
