/* $Id: RequesterManager.java,v 1.2 2007/12/06 07:47:15 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import jp.co.argo21.nautica.workflow.omg.WfRequester;
import jp.co.argo21.nautica.workflow.omg.WfResource;
import jp.co.argo21.nautica.workflow.security.SessionManager;
import jp.co.argo21.nautica.workflow.security.UserManager;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;
import jp.co.argo21.nautica.workflow.wfmc.Participant;

import org.apache.log4j.Logger;

/**
 * プロセス要求者(プロセスの実行や結果取得を行う管理実体)を管理するクラスである。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.2 $
 * @since   Nautica Workflow 1.0
 */
public class RequesterManager
{
	/** エンジンログ */
	private static Logger eLog = LogManager.getEngineLogger();
	
	/** ProcessManagerFactoryのシングルトン */
	private static RequesterManager singleton;
	
	/**
	 * RequesterManagerの生成と初期化を行う。
	 *
	 * @throws Exception 任意の例外
	 */
	static void create() throws Exception
	{
		try {
			singleton = new RequesterManager();
			singleton.init();
		} catch (Exception ex) {
			// リクエスタマネージャの初期化に失敗しました。
			String E0111 = StringManager.get("E0111");
			eLog.error(E0111);
			throw ex;
		}
	}

	/**
	 * RequesterManagerのインスタンスを返す。
	 *
	 * @return RequesterManager
	 */
	static RequesterManager getInstance()
	{
		return singleton;
	}
	
	/**
	 * RequesterManagerを生成する。
	 */
	private RequesterManager()
	{
	}
	
	/**
	 * RequesterManagerを初期化する。
	 *
	 * @throws Exception 任意の例外
	 */
	private void init() throws Exception
	{
	}

	/**
	 * セッションを起こしたユーザに対応したプロセス
	 * 生成リクエスタを返す。
	 *
	 * @param session セッションID
	 * @return プロセス生成リクエスタ
	 * @throws InvalidSessionException 指定されたセッションが無効の場合
	 */
	public WfRequester getRequesterBySession(String session)
	throws InvalidSessionException
	{
		try {
			SessionManagerFactory smf = SessionManagerFactory.getInstance();
			SessionManager sm = smf.getSessionManager();
			Participant part = sm.getSessionUser(session);
			WfResource rsc = new ResourceInternal(part);
			return new GeneralRequester(rsc);
		} catch (Exception ex) {
			// リクエスタの取得に失敗しました。
			String E0146 = StringManager.get("E0146") + "(SessionID = " + session + ")";
			throw new InvalidSessionException(E0146, ex);
		}
	}

	/**
	 * セッションを起こしたユーザに対応したプロセス
	 * 生成リクエスタを返す。
	 *
	 * @param uid
	 * @return プロセス生成リクエスタ
	 * @throws InvalidSessionException 指定されたユーザIDが無効の場合
	 */
	public WfRequester getRequesterByUserID(String uid)
	throws InvalidSessionException
	{
		try {
			ResourceManagerFactory rmf = ResourceManagerFactory.getInstance();
			UserManager um = rmf.getUserManager();
			Participant part = um.getUser(uid);
			WfResource rsc = new ResourceInternal(part);
			return new GeneralRequester(rsc);
		} catch (Exception ex) {
			// リクエスタの取得に失敗しました。
			String E0146 = StringManager.get("E0146") + "(UserID = " + uid + ")";
			throw new InvalidSessionException(E0146, ex);
		}
	}
}
