/* $Id: LogManager.java,v 1.2 2007/11/01 08:49:25 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;

import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

import jp.co.argo21.nautica.workflow.omg.WorkflowException;

/**
 * Log4Jを利用したメッセージ管理機構。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.2 $
 * @since   Nautica Workflow 1.0
 */
public class LogManager
{
	/** エンジンログ */
	private static final String ENGINE_LOGGER = "nautica.workflow.Engine";
	/** 監査ログ */
	private static final String AUDIT_LOGGER = "nautica.workflow.EventAudit";
	/** セキュリティログ */
	private static final String SECURITY_LOGGER = "nautica.workflow.Security";

	/** 初期化済みフラグ */
	private static boolean initialized = false;
	
	/**
	 * LogManagerの初期化を行う。
	 *
	 * @throws Exception 任意の例外
	 */
	static void create() throws WorkflowException
	{
		if (initialized) {
			throw new WorkflowException("Logging already initialized.");
		}
		File confFile = getConfigFile();
		try {
			Properties prop = new Properties();
			InputStream is = new FileInputStream(confFile);
			prop.load(is);
			is.close();
			PropertyConfigurator.configure(prop);
		} catch (Exception ex) {
			throw new WorkflowException("Logging configuration failed.", ex);
		}
		initialized = true;
	}
	
	/**
	 * 設定ファイルを返す。
	 *
	 * @return 設定ファイル
	 * @throws WorkflowException 取得時にエラーが起こった場合
	 */
	private static File getConfigFile()
	throws WorkflowException
	{
		String home = SystemChecker.getProperty(WorkflowEngineConstants.NAUTICA_HOME);
		String conf = SystemChecker.getProperty(WorkflowEngineConstants.NAUTICA_LOGGING_CONFIG);
		String separator = SystemChecker.getProperty("file.separator");
		String path = home
		                   + separator + "config"
						   + separator + conf;
		File confFile = new File(path);
	
		if (! confFile.exists()) {
			throw new WorkflowException(path + " is not found.");
		}
		if (! confFile.isFile()) {
			throw new WorkflowException(path + " is not file.");
		}
		return confFile;
	}
	
	/**
	 * エンジンログのロガーを返す。
	 *
	 * @return エンジンログのロガー
	 */
	public static Logger getEngineLogger()
	{
		return Logger.getLogger(ENGINE_LOGGER);
	}
	
	/**
	 * 監査ログのロガーを返す。
	 *
	 * @return 監査ログのロガー
	 */
	public static Logger getAuditLogger()
	{
		return Logger.getLogger(AUDIT_LOGGER);
	}
	
	/**
	 * セキュリティログのロガーを返す。
	 *
	 * @return セキュリティログのロガー
	 */
	public static Logger getSercurityLogger()
	{
		return Logger.getLogger(SECURITY_LOGGER);
	}
}
