/* $Id: LockManager.java,v 1.1 2007/12/03 07:18:02 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2007.  All rights reserved.
 */
package jp.co.argo21.nautica.workflow.engine;

import java.util.Map;
import java.util.HashMap;

/**
 * 
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
final class LockManager
{
	private static LockManager singleton = new LockManager();
	
	private Map<String, Lock> locks = new HashMap<String, Lock>();

	static LockManager getInstance()
	{
		return singleton;
	}
	
	private LockManager() {}
	
	public synchronized Lock getLock(String s)
	{
		Lock lock = locks.get(s);
		if (lock == null) {
			lock = new Lock();
			locks.put(s, lock);
		}
		return lock;
	}
	
	final class Lock
	{
		private Lock() {}
	}
}

