/* $Id: FormalParameterBean.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import jp.co.argo21.nautica.workflow.definition.ParameterDefinition;
import jp.co.argo21.nautica.workflow.wfmc.FormalParameter;

/**
 * プロセスインスタンス用の形式パラメータ格納用オブジェクト。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class FormalParameterBean implements FormalParameter, ParameterDefinition
{
	/** シリアルバージョンUID */
	private static final long serialVersionUID = 20050000000000001L;

	/** ID */
	private String id;
	/** パラメータ名 */
	private String name;
	/** パラメータ値 */
	private String value;
	/** パラメータ型 */
	private int type;
	/** 入出力モード */
	private int mode;
	/** 備考 */
	private String description;

	/**
	 * 形式パラメータ格納用オブジェクトを生成する。
	 */
	public FormalParameterBean()
	{
	}

	/**
	 * IDを返す。
	 *
	 * @return ID
	 * @see jp.co.argo21.nautica.workflow.definition.Definition#getID()
	 */
	public String getID()
	{
		return id;
	}

	/**
	 * パラメータ名を返す。
	 *
	 * @return パラメータ名
	 * @see jp.co.argo21.nautica.workflow.definition.Definition#getName()
	 */
	public String getName()
	{
		return name;
	}

	/**
	 * パラメータ値を返す。
	 *
	 * @return パラメータ値
	 * @see jp.co.argo21.nautica.workflow.omg.WfNameValue#getValue()
	 */
	public String getValue()
	{
		return value;
	}

	/**
	 * パラメータの型を返す。
	 *
	 * @return パラメータの型
	 * @see jp.co.argo21.nautica.workflow.definition.ParameterDefinition#getType()
	 */
	public int getType()
	{
		return type;
	}

	/**
	 * 入出力モードを返す。
	 *
	 * @return 入出力モード
	 * @see jp.co.argo21.nautica.workflow.definition.ParameterDefinition#getMode()
	 */
	public int getMode()
	{
		return mode;
	}

	/**
	 * 備考を返す。
	 *
	 * @return 備考
	 * @see jp.co.argo21.nautica.workflow.definition.Definition#getDescription()
	 */
	public String getDescription()
	{
		return description;
	}

	/**
	 * IDを設定する。
	 * 
	 * @param id IDへの設定値
	 */
	public void setID(String id)
	{
		this.id = id;
	}

	/**
	 * パラメータ名を設定する。
	 * 
	 * @param name パラメータ名
	 */
	public void setName(String name)
	{
		this.name = name;
	}

	/**
	 * パラメータ値を設定する。
	 * 
	 * @param value パラメータ値
	 */
	public void setValue(String value)
	{
		this.value = value;
	}

	/**
	 * パラメータ型を設定する。
	 * 
	 * @param type パラメータ型
	 */
	public void setType(int type)
	{
		this.type = type;
	}

	/**
	 * 入出力モードを設定する。
	 * 
	 * @param mode 入出力モード
	 */
	public void setMode(int mode)
	{
		this.mode = mode;
	}

	/**
	 * 備考を設定する。
	 * 
	 * @param description 備考
	 */
	public void setDescription(String description)
	{
		this.description = description;
	}
}
