/* $Id: CreateProcessEventObject.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import jp.co.argo21.nautica.workflow.omg.WfCreateProcessEvent;
import jp.co.argo21.nautica.workflow.omg.WfExecutionObject;

/**
 * プロセス生成イベントを表す。このクラスは、互換性のために用意されているだけで
 * 現在のエンジンでは使われていない。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class CreateProcessEventObject extends WorkflowEventObject
implements WfCreateProcessEvent
{
	/** シリアルバージョンUID */
	private static final long serialVersionUID = 20050000000000001L;

	/**
	 * プロセス生成イベントを生成する。
	 *
	 * @param type イベントの種類
	 * @param source イベントを引き起こしたWfExecutionObject
	 * @param timestamp イベント発生日時
	 * @param processManagerName プロセスマネージャ名
	 * @param processManagerVersion プロセスマネージャのバージョン
	 * @param processID プロセスID
	 * @param processName プロセス名
	 * @param activityID アクティビティID
	 */
	public CreateProcessEventObject(String type, WfExecutionObject source,
			String timestamp, String processManagerName,
			String processManagerVersion, String processID, String processName,
			String activityID)
	{
		super(type, source, timestamp, processManagerName, processManagerVersion,
				processID, processName, activityID, "");
	}
}
