/* $Id: AuditSuffix.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

/**
 * 監査ログの接尾辞(suffix)の情報を保持するクラス。
 * 必須項目である ExtentionNumber と ExtentionType のみを
 * 実装している。
 * 
 * @author  mmanabe(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class AuditSuffix {
    
    /** ExtensionNumber */
    private int extNumber = 0;
    
    /** ExtensionType */
    private String extType = "";
    
    /**
     * 拡張の数と型を設定する。
     * 
     * @param extNumber 拡張の数
     * @param extType   拡張の型
     */
    AuditSuffix(int extNumber, String extType) {
        this.extNumber = extNumber;
        this.extType = extType;
    }
    
    /**
     * デフォルトコンストラクタ。
     */
    AuditSuffix() {
        // 何もしない
    }
    
    /**
     * 拡張の数を設定する。
     * 
     * @param extNumber 拡張の数
     */
    void setExtNumber(int extNumber) {
        this.extNumber = extNumber;
    }
    
    /**
     * 拡張の型を設定する。
     * 
     * @param extType 拡張の型
     */
    void setExtType(String extType) {
        this.extType = extType;
    }
                
    /**
     * 監査ログ接尾辞の文字列表現を返す。
     * 拡張情報がない場合は ExtensionNumber のみを返す。
     * 
     * @return 監査ログ接尾辞情報
     */
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("(ExtensionNumber = " + extNumber + ")");        
        sb.append("(ExtensionType=" + extType + ")");
        
        return sb.toString();
    }
}