/* $Id: AuditDataRecord.java,v 1.2 2007/11/05 09:50:54 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import java.util.HashMap;
import java.util.Map;

import jp.co.argo21.nautica.workflow.wfmc.Attribute;

/**
 * 監査ログの情報を保持するクラス。
 * 監査ログは、CWAD接頭辞、データ要素(イベントごとに異なる)、CWAD接尾辞から成る。
 * 
 * @author  mmanabe(Argo 21, Corp.)
 * @version $Revision: 1.2 $
 * @since   Nautica Workflow 1.0
 */
public class AuditDataRecord {
    
    private AuditPrefix prefix;
    private AuditSuffix suffix;
    private Map<String, String> elements = new HashMap<String, String>();
    
    /**
     * CWAD接頭辞とCWAD接尾辞を設定する。
     * 
     * @param prefix CWAD接頭辞
     * @param suffix CWAD接尾辞
     */
    AuditDataRecord(AuditPrefix prefix, AuditSuffix suffix) {
        this.prefix = prefix;
        this.suffix = suffix;
    }
    
    /**
     * 監査ログのデータ要素を設定する。
     * 
     * @param name  要素名
     * @param value 値
     */
    void setDataElement(String name, String value) {
        elements.put(name, value);
    }
    
    /**
     * 監査ログのデータ要素を設定する。
     * 
     * @param name  要素名
     * @param value 値
     */
    void setDataElement(String name, int value) {
        elements.put(name, Integer.toString(value));
    }
    
    /**
     * 監査ログのデータ要素を設定する。
     * 値が null の場合は、文字列として "NULL" をセットする。
     * 
     * @param name  要素名
     * @param value 値
     */
    void setDataElement(String name, Object value) {
        if (value == null) {
            setDataElement(name, "NULL");
        } else {
            setDataElement(name, value.toString());
        }
    }
    
    /**
     * 監査ログのデータ要素として、配列中のプロセスインスタンス属性
     * の名前、型、値を設定する。
     * 
     * @param attrs Attribute配列
     */
    void setDataElement(Attribute[] attrs) {
        if (attrs != null) {
            for (int i = 0; i < attrs.length; i++) {
                setDataElement("AttributeName" + i, attrs[i].getName());
				setDataElement("AttributeType" + i, attrs[i].getType());
				setDataElement("Attributevalue" + i, attrs[i].getValue());
            }
        }
    }
    
    /**
     * 監査ログの文字列表現を返す。
     * 
     * @return 監査ログ情報
     */
    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (String key : elements.keySet()) {
            String value = (String) elements.get(key);
            sb.append("(" + key + " = " + value + ")");
        }
                
        return prefix + sb.toString() + suffix;        
    }
}