/* $Id: ComponentUtils.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2007.  All rights reserved.
 */
package jp.co.argo21.nautica.workflow.ejb;

import jp.co.argo21.nautica.workflow.engine.InterWorkflowConnectorFactory;
import jp.co.argo21.nautica.workflow.engine.RepositoryLoader;
import jp.co.argo21.nautica.workflow.engine.ResourceManagerFactory;
import jp.co.argo21.nautica.workflow.engine.ResourceManagerFactorySource;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.security.OrganizationManager;
import jp.co.argo21.nautica.workflow.security.RoleManager;
import jp.co.argo21.nautica.workflow.security.UserManager;
import jp.co.argo21.nautica.workflow.util.GeronimoUtils;
import jp.co.argo21.nautica.workflow.wfmc.ConnectionFailedException;
import jp.co.argo21.nautica.workflow.wfmc.DefinitionRepository;
import jp.co.argo21.nautica.workflow.wfmc.InterWorkflowConnector;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;
import jp.co.argo21.nautica.workflow.wfmc.WorkItemHandler;
import jp.co.argo21.nautica.workflow.wfmc.WorkflowAdminHandler;
import jp.co.argo21.nautica.workflow.wfmc.WorkflowEngineHandler;
import jp.co.argo21.nautica.workflow.wfmc.WorkflowSecurityException;
import jp.co.argo21.nautica.workflow.wfmc.WorkflowServiceManager;

public class ComponentUtils
{
	public static final String WORKFLOW_SERVICE_MANAGER_GBEAN = "WorkflowServiceManager";

	static WorkflowServiceManager getWorkflowServiceManager()
	throws ConnectionFailedException
	{
		try {
			return (WorkflowServiceManager)GeronimoUtils.getGBean(WORKFLOW_SERVICE_MANAGER_GBEAN);
		} catch (Exception ex) {
			throw new ConnectionFailedException(ex.getMessage(), ex);
		}
	}

	static WorkflowServiceManager getWorkflowServiceManager(String session)
	throws InvalidSessionException
	{
		try {
			return (WorkflowServiceManager)GeronimoUtils.getGBean(WORKFLOW_SERVICE_MANAGER_GBEAN);
		} catch (Exception ex) {
			throw new InvalidSessionException(ex.getMessage(), ex);
		}
	}

	static InterWorkflowConnector getInterWorkflowConnector()
	throws WorkflowException
	{
		try {
			InterWorkflowConnectorFactory factory =
				(InterWorkflowConnectorFactory)GeronimoUtils.getGBean(WORKFLOW_SERVICE_MANAGER_GBEAN);
			return factory.getInterWorkflowConnector();
		} catch (Exception ex) {
			throw new WorkflowException(ex.getMessage(), ex);
		}
	}

	static DefinitionRepository getDefinitionRepository(String session)
	throws InvalidSessionException
	{
		WorkflowServiceManager manager;
		try {
			manager = (WorkflowServiceManager)GeronimoUtils.getGBean(WORKFLOW_SERVICE_MANAGER_GBEAN);
			return manager.getDefinitionRepository(session);
		} catch (Exception ex) {
			throw new InvalidSessionException(ex.getMessage(), ex);
		}
	}

	static RepositoryLoader getRepositoryLoader(String session)
	throws InvalidSessionException
	{
		WorkflowServiceManager manager;
		try {
			manager = (WorkflowServiceManager)GeronimoUtils.getGBean(WORKFLOW_SERVICE_MANAGER_GBEAN);
			return (RepositoryLoader)manager.getDefinitionRepository(session);
		} catch (Exception ex) {
			throw new InvalidSessionException(ex.getMessage(), ex);
		}
	}

	static WorkflowAdminHandler getWorkflowAdminHandler(String session)
	throws InvalidSessionException
	{
		WorkflowServiceManager manager;
		try {
			manager = (WorkflowServiceManager)GeronimoUtils.getGBean(WORKFLOW_SERVICE_MANAGER_GBEAN);
			return manager.getWorkflowAdminHandler(session);
		} catch (Exception ex) {
			throw new InvalidSessionException(ex.getMessage(), ex);
		}
	}

	static WorkflowEngineHandler getWorkflowEngineHandler(String session)
	throws InvalidSessionException
	{
		WorkflowServiceManager manager;
		try {
			manager = (WorkflowServiceManager)GeronimoUtils.getGBean(WORKFLOW_SERVICE_MANAGER_GBEAN);
			return manager.getWorkflowEngineHandler(session);
		} catch (Exception ex) {
			throw new InvalidSessionException(ex.getMessage(), ex);
		}
	}

	static WorkItemHandler getWorkItemHandler(String session)
	throws InvalidSessionException
	{
		WorkflowServiceManager manager;
		try {
			manager = (WorkflowServiceManager)GeronimoUtils.getGBean(WORKFLOW_SERVICE_MANAGER_GBEAN);
			return manager.getWorkItemHandler(session);
		} catch (Exception ex) {
			throw new InvalidSessionException(ex.getMessage(), ex);
		}
	}

	static OrganizationManager getOrganizationManager()
	throws WorkflowSecurityException
	{
		ResourceManagerFactorySource src;
		try {
			src = (ResourceManagerFactorySource)GeronimoUtils.getGBean(WORKFLOW_SERVICE_MANAGER_GBEAN);
			ResourceManagerFactory factory = src.getResourceManagerFactory();
			return factory.getOrganizationManager();
		} catch (Exception ex) {
			throw new WorkflowSecurityException(ex.getMessage(), ex);
		}
	}

	static RoleManager getRoleManager()
	throws WorkflowSecurityException
	{
		ResourceManagerFactorySource src;
		try {
			src = (ResourceManagerFactorySource)GeronimoUtils.getGBean(WORKFLOW_SERVICE_MANAGER_GBEAN);
			ResourceManagerFactory factory = src.getResourceManagerFactory();
			return factory.getRoleManager();
		} catch (Exception ex) {
			throw new WorkflowSecurityException(ex.getMessage(), ex);
		}
	}

	static UserManager getUserManager()
	throws WorkflowSecurityException
	{
		ResourceManagerFactorySource src;
		try {
			src = (ResourceManagerFactorySource)GeronimoUtils.getGBean(WORKFLOW_SERVICE_MANAGER_GBEAN);
			ResourceManagerFactory factory = src.getResourceManagerFactory();
			return factory.getUserManager();
		} catch (Exception ex) {
			throw new WorkflowSecurityException(ex.getMessage(), ex);
		}
	}
}
