/* $Id: ParameterDefinitionImpl.java,v 1.1 2007/10/29 02:55:37 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2002.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.definition.impl;

import org.wfmc.x2002.xpdl10.BasicTypeDocument;
import org.wfmc.x2002.xpdl10.DataTypeDocument;
import org.wfmc.x2002.xpdl10.FormalParameterDocument;

import jp.co.argo21.nautica.workflow.definition.ParameterDefinition;
import jp.co.argo21.nautica.workflow.util.IDGenerator;
import jp.co.argo21.nautica.workflow.util.StringUtils;

/**
 * ParameterDefinitionインタフェースの実装クラスである。
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class ParameterDefinitionImpl implements ParameterDefinition
{
	/** シリアルバージョンUID */
	private static final long serialVersionUID = 20050000000000001L;

	/** ID */
	private String id;
	/** 名称 */
	@SuppressWarnings("unused")
	private String name;
	/** 備考 */
	private String description;
	/** パラメータ型 */
	private int type;
	/** 入出力モード */
	private int mode;
	
	/**
	 * パラメータを生成する。
	 * 
	 * @param pm	XmlObject
	 */
	public ParameterDefinitionImpl(FormalParameterDocument.FormalParameter pm)
	{
		String id = pm.getId();
		if (StringUtils.checkNull(id)) {
			setID(IDGenerator.generate(ID_PREFIX));
		} else {
			setID(id);
		}

		setDescription(pm.getDescription());

		if (pm.isSetMode()) {
			setMode(pm.getMode().intValue());
		}
		
		DataTypeDocument.DataType t = pm.getDataType();
		if (t.isSetBasicType()) {
			BasicTypeDocument.BasicType bt = t.getBasicType();
			BasicTypeDocument.BasicType.Type.Enum type = bt.getType();
			setType(type.intValue());
		}
	}

	/**
	 * 説明を返す。
	 * 
	 * @return 説明
	 * @see jp.co.argo21.nautica.workflow.definition.Definition#getDescription()
	 */
	public String getDescription()
	{
		return description;
	}

	/**
	 * IDを返す。
	 * 
	 * @return ID
	 * @see jp.co.argo21.nautica.workflow.definition.Definition#getID()
	 */
	public String getID()
	{
		return id;
	}

	/**
	 * 名称を返す。
	 * 
	 * @return 名称
	 * @see jp.co.argo21.nautica.workflow.definition.Definition#getName()
	 */
	public String getName()
	{
		return getID();
	}

	/**
	 * 入出力モードを返す。
	 * 
	 * @return	入出力モード
	 * @see jp.co.argo21.nautica.workflow.definition.ParameterDefinition#getMode()
	 */
	public int getMode()
	{
		return mode;
	}

	/**
	 * パラメータ型を返す。
	 * 
	 * @return	パラメータ型
	 * @see jp.co.argo21.nautica.workflow.definition.ParameterDefinition#getType()
	 */
	public int getType()
	{
		return type;
	}

	/**
	 * IDを設定する。
	 * 
	 * @param id	ID
	 */	
	private void setID(String id)
	{
		this.id = id;
	}

	/**
	 * 説明を設定する。
	 * 
	 * @param desc 説明
	 */
	private void setDescription(String desc)
	{
		this.description = desc;
	}

	/**
	 * 名称を設定する。ただし、このメソッドは何もしない。
	 * 
	 * @param name 名称
	 */
	@SuppressWarnings("unused")
	private void setName(String name)
	{
		//NOP
	}

	/**
	 * 入出力モードを設定する。
	 * 
	 * @param i	入出力モード
	 */
	private void setMode(int i)
	{
		mode = i;
	}

	/**
	 * パラメータ型を設定する。
	 * 
	 * @param i	パラメータ型
	 */
	private void setType(int i)
	{
		type = i;
	}
}
