/* $Id: DefinitionLoader.java,v 1.1 2007/10/29 02:55:37 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.definition.impl;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

import jp.co.argo21.nautica.workflow.definition.PackageDefinition;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.engine.SystemChecker;

import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.wfmc.x2002.xpdl10.PackageDocument;

/**
 * XPDL定義ファイルローダーである。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class DefinitionLoader
{
	/** エンジンログ */
	@SuppressWarnings("unused")
	private static Logger eLog = LogManager.getEngineLogger();
	
	/** 定義ファイル配置位置 */
	private String definitionHome;
	
	/**
	 * XPDL定義ファイルローダーを生成する。
	 *
	 * @param home 定義ファイル配置位置
	 */
	public DefinitionLoader(String home)
	{
		String separator = SystemChecker.getProperty("file.separator");

		if (home == null || home.trim().equals("")) {
			definitionHome = "./";
		} else {
			if (home.trim().endsWith(separator) == false) {
				home += separator;
			}
			definitionHome = home;
		}
	}

	/**
	 * ワークフロー定義ドキュメントをロードする。
	 * 
	 * @param fn XPDLファイル名
	 * @throws XmlException XML例外
	 * @throws IOException 入出力例外
	 */
	public PackageDefinition load(String fn)
	throws XmlException, IOException
	{
		String fileName = definitionHome + fn;
		InputStream in = new FileInputStream(fileName);
		XmlOptions opts = new XmlOptions();
		opts.setCharacterEncoding("utf-8");

		PackageDocument doc = PackageDocument.Factory.parse(in, opts);
		in.close();
		
		return new PackageDefinitionImpl(doc);
	}
}
