/* $Id: ProcessDefinition.java,v 1.2 2007/11/05 09:50:54 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.definition;

import java.util.List;

import org.wfmc.x2002.xpdl10.ProcessHeaderDocument;
import org.wfmc.x2002.xpdl10.WorkflowProcessDocument;

/**
 * プロセス定義用インタフェース
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.2 $
 * @since   Nautica Workflow 1.0
 */
public interface ProcessDefinition extends Definition
{
	/** プロセスID接頭辞 */
	public static final String ID_PREFIX  = "PS";

	/** 論理座標幅取得キー */
	public static final String LOGICAL_WIDTH  = "LOGICAL_WIDTH";
	/** 論理座標高さ取得キー */
	public static final String LOGICAL_HEIGHT = "LOGICAL_HEIGHT";

	/** ルートプロセス */
	public static final int PUBLIC  = WorkflowProcessDocument.WorkflowProcess.AccessLevel.INT_PUBLIC;
	/** サブプロセス */
	public static final int PRIVATE = WorkflowProcessDocument.WorkflowProcess.AccessLevel.INT_PRIVATE;

	/** 年 */
	public static final int YEAR   = ProcessHeaderDocument.ProcessHeader.DurationUnit.INT_Y;
	/** 月 */
	public static final int MONTH  = ProcessHeaderDocument.ProcessHeader.DurationUnit.INT_M;
	/** 日 */
	public static final int DAY    = ProcessHeaderDocument.ProcessHeader.DurationUnit.INT_D;
	/** 時間 */
	public static final int HOUR   = ProcessHeaderDocument.ProcessHeader.DurationUnit.INT_H;
	/** 分 */
	public static final int MINUTE = ProcessHeaderDocument.ProcessHeader.DurationUnit.INT_M_2;
	/** 秒 */
	public static final int SECOND = ProcessHeaderDocument.ProcessHeader.DurationUnit.INT_S;

	/**
	 * 期間単位を返す。
	 * 
	 * @return	期間単位
	 */
	public int getDurationUnit();

	/**
	 * 実行期限を返す。
	 * 
	 * @return	実行期限
	 */
	public int getLimit();

	/**
	 * アクセスレベルを返す。
	 * 
	 * @return	アクセスレベル
	 */
	public int getAccessLevel();

	/**
	 * 論理座標幅を返す。
	 * 
	 * @return	論理座標幅
	 */
	public int getLogicalWidth();

	/**
	 * 論理座標高さを返す。
	 * 
	 * @return	論理座標高さ
	 */
	public int getLogicalHeight();

	/**
	 * 通知者一覧を返す。
	 * 
	 * @return	通知者一覧
	 */
	public List<String> getResponsibles();

	/**
	 * パラメータ一覧を返す。
	 * 
	 * @return	パラメータ一覧
	 */
	public List<ParameterDefinition> getParameters();

	/**
	 * アクティビティ一覧を返す。
	 * 
	 * @return	アクティビティ一覧
	 */
	public List<ActivityDefinition> getActivities();

	/**
	 * 遷移一覧を返す。
	 * 
	 * @return	遷移一覧
	 */
	public List<TransitionDefinition> getTransitions();
}
