/* $Id: ParameterDefinition.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2002.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.definition;

import org.wfmc.x2002.xpdl10.BasicTypeDocument;
import org.wfmc.x2002.xpdl10.FormalParameterDocument;

/**
 * パラメータ定義用インタフェース
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public interface ParameterDefinition extends Definition
{
	/** パラメータID接頭辞 */
	public static final String ID_PREFIX  = "PM";

	/** 入力 */
	public static final int IN    = FormalParameterDocument.FormalParameter.Mode.INT_IN;
	/** 出力 */
	public static final int OUT   = FormalParameterDocument.FormalParameter.Mode.INT_OUT;
	/** 入出力 */
	public static final int INOUT = FormalParameterDocument.FormalParameter.Mode.INT_INOUT;

	/** 文字列 */
	public static final int STRING    = BasicTypeDocument.BasicType.Type.INT_STRING;
	/** 実数 */
	public static final int FLOAT     = BasicTypeDocument.BasicType.Type.INT_FLOAT;
	/** 整数 */
	public static final int INTEGER   = BasicTypeDocument.BasicType.Type.INT_INTEGER;
	/** 日時 */
	public static final int DATETIME  = BasicTypeDocument.BasicType.Type.INT_DATETIME;
	/** 真理値 */
	public static final int BOOLEAN   = BasicTypeDocument.BasicType.Type.INT_BOOLEAN;

	/**
	 * パラメータ型を返す。
	 * 
	 * @return	パラメータ型
	 */
	public int getType();

	/**
	 * 入出力モードを返す。
	 * 
	 * @return	入出力モード
	 */
	public int getMode();
}
