/* $Id: VariableHistoryBean.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess;

import java.io.Serializable;
import java.sql.Timestamp;

/**
 * このクラスは、プロセス変数変更履歴テーブル(VARIABLE_HISTORY)に対応する情報を保持する。
 *
 * @version	$Revision: 1.1 $, $Date: 2007/10/29 02:55:36 $
 * @since	Nautica Workflow 1.0
 */
public class VariableHistoryBean implements Serializable
{
	/** シリアルバージョンUID */
	private static final long serialVersionUID = 20050000000000001L;

	/**
	 * プロセス変数インスタンスID
	 */
	protected String varID;

	/**
	 * プロセスインスタンスID
	 */
	protected String procID;

	/**
	 * プロセス変数定義ID
	 */
	protected String varDefID;

	/**
	 * 変数型
	 */
	protected int type;

	/**
	 * 更新前の変数値
	 */
	protected String prevValue;

	/**
	 * 更新後の変数値
	 */
	protected String newValue;

	/**
	 * 更新日時
	 */
	protected Timestamp updateDate;

	/**
	 * 更新事由
	 */
	protected String reason;

	/**
	 * アクティビティID
	 */
	protected String actID;

	/**
	 * プロセス変数変更履歴オブジェクトを生成する。
	 */
	public VariableHistoryBean()
	{
	}

	/**
	 * プロセス変数インスタンスIDを取得する。
	 *
	 * @return	プロセス変数インスタンスID
	 */
	public String getVarID()
	{
		if (varID == null) return "";
		else return varID;
	}
	
	/**
	 * プロセス変数インスタンスIDを設定する。
	 *
	 * @param	varID	プロセス変数インスタンスID
	 */
	public void setVarID(String varID)
	{
		this.varID = varID;
	}

	/**
	 * プロセスインスタンスIDを取得する。
	 *
	 * @return	プロセスインスタンスID
	 */
	public String getProcID()
	{
		if (procID == null) return "";
		else return procID;
	}
	
	/**
	 * プロセスインスタンスIDを設定する。
	 *
	 * @param	procID	プロセスインスタンスID
	 */
	public void setProcID(String procID)
	{
		this.procID = procID;
	}

	/**
	 * プロセス変数定義IDを取得する。
	 *
	 * @return	プロセス変数定義ID
	 */
	public String getVarDefID()
	{
		if (varDefID == null) return "";
		else return varDefID;
	}
	
	/**
	 * プロセス変数定義IDを設定する。
	 *
	 * @param	varDefID	プロセス変数定義ID
	 */
	public void setVarDefID(String varDefID)
	{
		this.varDefID = varDefID;
	}

	/**
	 * 変数型を取得する。
	 *
	 * @return	変数型
	 */
	public int getType()
	{
		return type;
	}
	
	/**
	 * 変数型を設定する。
	 *
	 * @param	type	変数型
	 */
	public void setType(int type)
	{
		this.type = type;
	}

	/**
	 * 更新前の変数値を取得する。
	 *
	 * @return	更新前の変数値
	 */
	public String getPrevValue()
	{
		if (prevValue == null) return "";
		else return prevValue;
	}
	
	/**
	 * 更新前の変数値を設定する。
	 *
	 * @param	prevValue	更新前の変数値
	 */
	public void setPrevValue(String prevValue)
	{
		this.prevValue = prevValue;
	}

	/**
	 * 更新後の変数値を取得する。
	 *
	 * @return	更新後の変数値
	 */
	public String getNewValue()
	{
		if (newValue == null) return "";
		else return newValue;
	}
	
	/**
	 * 更新後の変数値を設定する。
	 *
	 * @param	newValue	更新後の変数値
	 */
	public void setNewValue(String newValue)
	{
		this.newValue = newValue;
	}

	/**
	 * 更新日時を取得する。
	 *
	 * @return	更新日時
	 */
	public Timestamp getUpdateDate()
	{
		return updateDate;
	}
	
	/**
	 * 更新日時を設定する。
	 *
	 * @param	updateDate	更新日時
	 */
	public void setUpdateDate(Timestamp updateDate)
	{
		this.updateDate = updateDate;
	}

	/**
	 * 更新事由を取得する。
	 *
	 * @return	更新事由
	 */
	public String getReason()
	{
		if (reason == null) return "";
		else return reason;
	}
	
	/**
	 * 更新事由を設定する。
	 *
	 * @param	reason	更新事由
	 */
	public void setReason(String reason)
	{
		this.reason = reason;
	}

	/**
	 * アクティビティIDを返す。
	 *
	 * @return アクティビティID
	 */
	public String getActivityID()
	{
		return actID;
	}

	/**
	 * アクティビティIDを設定する。
	 * 
	 * @param aid アクティビティID
	 */
	public void setActivityID(String aid)
	{
		this.actID = aid;
	}

	/**
	 * ガーベジコレクタによる当該オブジェクトの解放処理を行う。
	 *
	 * @throws	Throwable	任意の例外
	 */
	protected void finalize() throws Throwable
	{
		// ここに独自の解放処理を実装する。
		super.finalize();
	}
	
	/**
	 * 引数のオブジェクトとの比較を行い、同一性を判定する。
	 *
	 * @param	obj	比較するオブジェクト
	 * @return	判定結果
	 */
	public boolean equals(Object obj)
	{
		boolean b = super.equals(obj);
		return b;
	}
}

