/* $Id: VariableBean.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess;

import java.sql.Timestamp;

import jp.co.argo21.nautica.workflow.wfmc.Attribute;

/**
 * このクラスは、プロセス変数インスタンステーブル(VARIABLE)に対応する情報を保持する。
 *
 * @version	$Revision: 1.1 $, $Date: 2007/10/29 02:55:36 $
 * @since	Nautica Workflow 1.0
 */
public class VariableBean implements Attribute
{
	/** シリアルバージョンUID */
	private static final long serialVersionUID = 20050000000000001L;

	/** ID接頭辞 */
	public static final String ID_PREFIX  = "VRI";

	/**
	 * プロセス変数インスタンスID
	 */
	protected String varID;

	/**
	 * プロセスインスタンスID
	 */
	protected String procID;

	/**
	 * プロセス変数定義ID
	 */
	protected String varDefID;

	/**
	 * 変数名
	 */
	protected String name;

	/**
	 * 変数型
	 */
	protected int type;

	/**
	 * 変数値
	 */
	protected String value;

	/**
	 * 最新状態更新日時
	 */
	protected String updateDate;

	/**
	 * プロセス変数インスタンスオブジェクトを生成する。
	 */
	public VariableBean()
	{
	}

	/**
	 * プロセス変数インスタンスIDを取得する。
	 *
	 * @return	プロセス変数インスタンスID
	 */
	public String getID()
	{
		if (varID == null) return "";
		else return varID;
	}
	
	/**
	 * プロセス変数インスタンスIDを設定する。
	 *
	 * @param	varID	プロセス変数インスタンスID
	 */
	public void setID(String varID)
	{
		this.varID = varID;
	}

	/**
	 * プロセスインスタンスIDを取得する。
	 *
	 * @return	プロセスインスタンスID
	 */
	public String getProcessID()
	{
		if (procID == null) return "";
		else return procID;
	}
	
	/**
	 * プロセスインスタンスIDを設定する。
	 *
	 * @param	procID	プロセスインスタンスID
	 */
	public void setProcessID(String procID)
	{
		this.procID = procID;
	}

	/**
	 * プロセス変数定義IDを取得する。
	 *
	 * @return	プロセス変数定義ID
	 */
	public String getVariableDefinitionID()
	{
		if (varDefID == null) return "";
		else return varDefID;
	}
	
	/**
	 * プロセス変数定義IDを設定する。
	 *
	 * @param	varDefID	プロセス変数定義ID
	 */
	public void setVariableDefinitionID(String varDefID)
	{
		this.varDefID = varDefID;
	}

	/**
	 * 変数名を取得する。
	 *
	 * @return	変数名
	 */
	public String getName()
	{
		if (name == null) return "";
		else return name;
	}
	
	/**
	 * 変数名を設定する。
	 *
	 * @param	name	変数名
	 */
	public void setName(String name)
	{
		this.name = name;
	}

	/**
	 * 変数型を取得する。
	 *
	 * @return	変数型
	 */
	public int getType()
	{
		return type;
	}
	
	/**
	 * 変数型を設定する。
	 *
	 * @param	type	変数型
	 */
	public void setType(int type)
	{
		this.type = type;
	}

	/**
	 * 変数値を取得する。
	 *
	 * @return	変数値
	 */
	public String getValue()
	{
		if (value == null) return "";
		else return value;
	}
	
	/**
	 * 変数値を設定する。
	 *
	 * @param	value	変数値
	 */
	public void setValue(String value)
	{
		this.value = value;
	}

	/**
	 * 最新状態更新日時を取得する。
	 *
	 * @return	最新状態更新日時
	 */
	public Timestamp getUpdateDate()
	{
		return Timestamp.valueOf(updateDate);
	}
	
	/**
	 * 最新状態更新日時を設定する。
	 *
	 * @param	updateDate	最新状態更新日時
	 */
	public void setUpdateDate(Timestamp updateDate)
	{
		this.updateDate = updateDate.toString();
	}

	/**
	 * ガーベジコレクタによる当該オブジェクトの解放処理を行う。
	 *
	 * @throws	Throwable	任意の例外
	 */
	protected void finalize() throws Throwable
	{
		// ここに独自の解放処理を実装する。
		super.finalize();
	}
	
	/**
	 * 引数のオブジェクトとの比較を行い、同一性を判定する。
	 *
	 * @param	obj	比較するオブジェクト
	 * @return	判定結果
	 */
	public boolean equals(Object obj)
	{
		boolean b = super.equals(obj);
		return b;
	}
}

