/* $Id: SourceActivityBean.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess;

import java.io.Serializable;

/**
 * このクラスは、起動元アクティビティテーブル(ETAACTIVITY)に対応する情報を保持する。
 *
 * @version	$Revision: 1.1 $, $Date: 2007/10/29 02:55:36 $
 * @since	Nautica Workflow 1.0
 */
public class SourceActivityBean implements Serializable
{
	/** シリアルバージョンUID */
	private static final long serialVersionUID = 20050000000000001L;

	/**
	 * 起動先プロセスID
	 */
	protected String processID;

	/**
	 * 起動元エンジンID
	 */
	protected String engineID;

	/**
	 * 起動元プロセスID
	 */
	protected String rootProcID;

	/**
	 * 起動元アクティビティID
	 */
	protected String rootActID;

	/**
	 * 起動元アクティビティオブジェクトを生成する。
	 */
	public SourceActivityBean()
	{
	}

	/**
	 * 起動先プロセスIDを取得する。
	 *
	 * @return	起動先プロセスID
	 */
	public String getProcessID()
	{
		if (processID == null) return "";
		else return processID;
	}
	
	/**
	 * 起動先プロセスIDを設定する。
	 *
	 * @param	processID	起動先プロセスID
	 */
	public void setProcessID(String processID)
	{
		this.processID = processID;
	}

	/**
	 * 起動元エンジンIDを取得する。
	 *
	 * @return	起動元エンジンID
	 */
	public String getEngineID()
	{
		if (engineID == null) return "";
		else return engineID;
	}
	
	/**
	 * 起動元エンジンIDを設定する。
	 *
	 * @param	engineID	起動元エンジンID
	 */
	public void setEngineID(String engineID)
	{
		this.engineID = engineID;
	}

	/**
	 * 起動元プロセスIDを取得する。
	 *
	 * @return	起動元プロセスID
	 */
	public String getRootProcID()
	{
		if (rootProcID == null) return "";
		else return rootProcID;
	}
	
	/**
	 * 起動元プロセスIDを設定する。
	 *
	 * @param	rootProcID	起動元プロセスID
	 */
	public void setRootProcID(String rootProcID)
	{
		this.rootProcID = rootProcID;
	}

	/**
	 * 起動元アクティビティIDを取得する。
	 *
	 * @return	起動元アクティビティID
	 */
	public String getRootActID()
	{
		if (rootActID == null) return "";
		else return rootActID;
	}
	
	/**
	 * 起動元アクティビティIDを設定する。
	 *
	 * @param	rootActID	起動元アクティビティID
	 */
	public void setRootActID(String rootActID)
	{
		this.rootActID = rootActID;
	}

	/**
	 * ガーベジコレクタによる当該オブジェクトの解放処理を行う。
	 *
	 * @throws	Throwable	任意の例外
	 */
	protected void finalize() throws Throwable
	{
		// ここに独自の解放処理を実装する。
		super.finalize();
	}
	
	/**
	 * 引数のオブジェクトとの比較を行い、同一性を判定する。
	 *
	 * @param	obj	比較するオブジェクト
	 * @return	判定結果
	 */
	public boolean equals(Object obj)
	{
		boolean b = super.equals(obj);
		return b;
	}
}

