/* $Id: ProcessBean.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess;

import java.sql.Timestamp;

import jp.co.argo21.nautica.workflow.wfmc.Process;

/**
 * このクラスは、プロセスインスタンステーブル(PROCESS)に対応する情報を保持する。
 *
 * @version	$Revision: 1.1 $, $Date: 2007/10/29 02:55:36 $
 * @since	Nautica Workflow 1.0
 */
public class ProcessBean implements Process
{
	/** シリアルバージョンUID */
	private static final long serialVersionUID = 20050000000000001L;

	/** ID接頭辞 */
	public static final String ID_PREFIX  = "PSI";

	/**
	 * プロセスインスタンスID
	 */
	protected String procID;

	/**
	 * プロセスインスタンス名
	 */
	protected String procName;

	/**
	 * パッケージID
	 */
	protected String packageID;

	/**
	 * プロセス定義ID
	 */
	protected String procDefID;

	/**
	 * 開始日時
	 */
	protected Timestamp startDate;

	/**
	 * 開始者
	 */
	protected String starterID;

	/**
	 * 実行期限
	 */
	protected Timestamp durationLimit;

	/**
	 * 状態
	 */
	protected int procState;

	/**
	 * 最新状態更新日時
	 */
	protected Timestamp updateDate;

	/**
	 * プロセスインスタンスオブジェクトを生成する。
	 */
	public ProcessBean()
	{
	}

	/**
	 * プロセスインスタンスIDを取得する。
	 *
	 * @return	プロセスインスタンスID
	 */
	public String getID()
	{
		if (procID == null) return "";
		else return procID;
	}
	
	/**
	 * プロセスインスタンスIDを設定する。
	 *
	 * @param	procID	プロセスインスタンスID
	 */
	public void setID(String procID)
	{
		this.procID = procID;
	}

	/**
	 * プロセスインスタンス名を取得する。
	 *
	 * @return	プロセスインスタンス名
	 */
	public String getName()
	{
		if (procName == null) return "";
		else return procName;
	}
	
	/**
	 * プロセスインスタンス名を設定する。
	 *
	 * @param	procName	プロセスインスタンス名
	 */
	public void setName(String procName)
	{
		this.procName = procName;
	}

	/**
	 * パッケージIDを取得する。
	 *
	 * @return	パッケージID
	 */
	public String getPackageID()
	{
		if (packageID == null) return "";
		else return packageID;
	}
	
	/**
	 * パッケージIDを設定する。
	 *
	 * @param	packageID	パッケージID
	 */
	public void setPackageID(String packageID)
	{
		this.packageID = packageID;
	}

	/**
	 * プロセス定義IDを取得する。
	 *
	 * @return	プロセス定義ID
	 */
	public String getProcDefinitionID()
	{
		if (procDefID == null) return "";
		else return procDefID;
	}
	
	/**
	 * プロセス定義IDを設定する。
	 *
	 * @param	procDefID	プロセス定義ID
	 */
	public void setProcDefinitionID(String procDefID)
	{
		this.procDefID = procDefID;
	}

	/**
	 * 開始日時を取得する。
	 *
	 * @return	開始日時
	 */
	public Timestamp getStartDate()
	{
		return startDate;
	}
	
	/**
	 * 開始日時を設定する。
	 *
	 * @param	startDate	開始日時
	 */
	public void setStartDate(Timestamp startDate)
	{
		this.startDate = startDate;
	}

	/**
	 * 開始者を取得する。
	 *
	 * @return	開始者
	 */
	public String getStarterID()
	{
		if (starterID == null) return "";
		else return starterID;
	}
	
	/**
	 * 開始者を設定する。
	 *
	 * @param	starterID	開始者
	 */
	public void setStarterID(String starterID)
	{
		this.starterID = starterID;
	}

	/**
	 * 実行期限を取得する。
	 *
	 * @return	実行期限
	 */
	public Timestamp getDurationLimit()
	{
		return durationLimit;
	}
	
	/**
	 * 実行期限を設定する。
	 *
	 * @param	durationLimit	実行期限
	 */
	public void setDurationLimit(Timestamp durationLimit)
	{
		this.durationLimit = durationLimit;
	}

	/**
	 * 状態を取得する。
	 *
	 * @return	状態
	 */
	public int getProcessState()
	{
		return procState;
	}
	
	/**
	 * 状態を設定する。
	 *
	 * @param	procState	状態
	 */
	public void setProcessState(int procState)
	{
		this.procState = procState;
	}

	/**
	 * 最新状態更新日時を取得する。
	 *
	 * @return	最新状態更新日時
	 */
	public Timestamp getUpdateDate()
	{
		return updateDate;
	}
	
	/**
	 * 最新状態更新日時を設定する。
	 *
	 * @param	updateDate	最新状態更新日時
	 */
	public void setUpdateDate(Timestamp updateDate)
	{
		this.updateDate = updateDate;
	}

	/**
	 * ガーベジコレクタによる当該オブジェクトの解放処理を行う。
	 *
	 * @throws	Throwable	任意の例外
	 */
	protected void finalize() throws Throwable
	{
		// ここに独自の解放処理を実装する。
		super.finalize();
	}
	
	/**
	 * 引数のオブジェクトとの比較を行い、同一性を判定する。
	 *
	 * @param	obj	比較するオブジェクト
	 * @return	判定結果
	 */
	public boolean equals(Object obj)
	{
		boolean b = super.equals(obj);
		return b;
	}
}