/* $Id: OrganizationManagerDAO.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess;

import java.sql.SQLException;

/**
 * OrganizationManagerDAOは、組織管理関連の各種APIを定義する。
 * 永続化されているデータにアクセスするためのインタフェースである。
 * 実際には、任意の組織管理システムを利用するために、
 * このインタフェースを利用した具体実装を用意しなければならない。
 * 
 * @author  mmanabe(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public interface OrganizationManagerDAO {

    /**
     * 指定された組織IDの組織情報を返す。
     * 該当する組織情報が存在しない場合は null を返す。
     * 
     * @param  oid 組織ID
     * @return 指定された組織IDの情報を持つOrganizationBean
     * @throws SQLException
     * @throws DAOException
     */
    public OrganizationBean findByOrganizationID(String oid)
    throws SQLException, DAOException;
    
    /**
     * 指定された組織のユーザ情報の配列を返す。
     * 該当するユーザ情報が存在しない場合は空の配列を返す。
     * 
     * @param  oid 組織ID
     * @return 指定された組織に所属するユーザ情報を持つUserBeanの配列
     * @throws SQLException
     * @throws DAOException
     */
    public UserBean[] findUsersByOrganizationID(String oid)
	throws SQLException, DAOException;
    
    /**
     * 指定されたユーザの所属する組織情報の配列を返す。
     * 該当する組織情報が存在しない場合は空の配列を返す。
     * 
     * @param  uid ユーザID
     * @return 指定されたユーザが所属する組織情報を持つOrganizationBeanの配列
     * @throws SQLException
     * @throws DAOException
     */
    public OrganizationBean[] findByUserID(String uid)
	throws SQLException, DAOException;
    
    /**
     * 指定された組織の上位組織情報を返す。
	 * 該当する上位組織情報が存在しない場合は null を返す。
	 *
	 * @param oid 組織ID
	 * @return OrganizationBean
     * @throws SQLException
     * @throws DAOException
     */
    public OrganizationBean findHigherByOrganizationID(String oid)
    throws SQLException, DAOException;
}
