/* $Id: OrganizationBean.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess;

import java.util.HashMap;
import java.util.Map;

import jp.co.argo21.nautica.workflow.security.Organization;
import jp.co.argo21.nautica.workflow.wfmc.Participant;

/**
 * このクラスは、組織情報を保持する
 * 
 * @author  mmanabe(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class OrganizationBean implements Organization {
    /** シリアルバージョンUID */
	private static final long serialVersionUID = 20050000000000001L;
	
    private String id;
    private String name;
    private Map<String, String> attributes = new HashMap<String, String>();
    private int type = Participant.ORGANIZATIONAL_UNIT;
    
    /**
     * 組織情報オブジェクトを生成する。
     *
     */
    public OrganizationBean() {
        // 処理なし。
    }
    
    
    /**
     * 組織IDを返す。
     * 
     * @return 組織ID
     * @see jp.co.argo21.nautica.workflow.wfmc.Participant#getID()
     */
    public String getID() {
        return id;
    }

    /**
     * 組織IDを設定する。
     * 
     * @param id 組織ID
     */
    public void setID(String id) {
        this.id = id;
    }

    /**
     * 組織名を返す。
     * 
     * @return 組織名
     * @see jp.co.argo21.nautica.workflow.wfmc.Participant#getName()
     */
    public String getName() {
        return name;
    }

    /**
     * 組織名を設定する。
     * 
     * @param name 組織名
     */
    public void setName(String name) {
        this.name = name;
    }
    
    /**
     * 参加者型を返す。
     * @return 参加者型
     * @see jp.co.argo21.nautica.workflow.wfmc.Participant#getType()
     */
    public int getType() {
        return type;
    }
    
    /**
     * 保持する属性を返す。
	 *
	 * @param  name 属性名
	 * @return 属性値
     * @see jp.co.argo21.nautica.workflow.wfmc.Participant#getAttribute(java.lang.String)
     */
    public String getAttribute(String name) {
        return (String) attributes.get(name);
    }

    /**
     * 属性を設定する。
	 *
	 * @param name  属性名
	 * @param value 属性値
     * @see jp.co.argo21.nautica.workflow.wfmc.Participant#setAttribute(java.lang.String, java.lang.String)
     */
    public void setAttribute(String name, String value) {
        attributes.put(name, value);
    }

    /**
     * 保持するすべての属性名を返す。
	 *
	 * @return 属性名の一覧
     * @see jp.co.argo21.nautica.workflow.wfmc.Participant#getAllAttributeNames()
     */
    public String[] getAllAttributeNames() {
        return (String[]) attributes.keySet().toArray(new String[attributes.size()]);
    }
}