/* $Id: ConcurrencyBlockBean.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess;

import java.io.Serializable;

/**
 * このクラスは、並行処理ブロックテーブル(CONCURRENCY_BLOCK)に対応する情報を保持する。
 *
 * @version	$Revision: 1.1 $, $Date: 2007/10/29 02:55:36 $
 * @since	Nautica Workflow 1.0
 */
public class ConcurrencyBlockBean implements Serializable
{
	/** シリアルバージョンUID */
	private static final long serialVersionUID = 20050000000000001L;

	/** ID接頭辞 */
	public static final String ID_PREFIX  = "CBI";

	/**
	 * ブロックID
	 */
	protected String blockID;

	/**
	 * 上位のブロックID
	 */
	protected String upperBlockID;

	/**
	 * プロセスインスタンスID
	 */
	protected String procID;

	/**
	 * ブロック開始アクティビティインスタンスID
	 */
	protected String actID;

	/**
	 * 並行処理ブロックオブジェクトを生成する。
	 */
	public ConcurrencyBlockBean()
	{
	}

	/**
	 * ブロックIDを取得する。
	 *
	 * @return	ブロックID
	 */
	public String getBlockID()
	{
		if (blockID == null) return "";
		else return blockID;
	}
	
	/**
	 * ブロックIDを設定する。
	 *
	 * @param	blockID	ブロックID
	 */
	public void setBlockID(String blockID)
	{
		this.blockID = blockID;
	}

	/**
	 * 上位のブロックIDを取得する。
	 *
	 * @return	上位のブロックID
	 */
	public String getUpperBlockID()
	{
		if (upperBlockID == null) return "";
		else return upperBlockID;
	}
	
	/**
	 * 上位のブロックIDを設定する。
	 *
	 * @param	upperBlockID	上位のブロックID
	 */
	public void setUpperBlockID(String upperBlockID)
	{
		this.upperBlockID = upperBlockID;
	}

	/**
	 * プロセスインスタンスIDを取得する。
	 *
	 * @return	プロセスインスタンスID
	 */
	public String getProcID()
	{
		if (procID == null) return "";
		else return procID;
	}
	
	/**
	 * プロセスインスタンスIDを設定する。
	 *
	 * @param	procID	プロセスインスタンスID
	 */
	public void setProcID(String procID)
	{
		this.procID = procID;
	}

	/**
	 * ブロック開始アクティビティインスタンスIDを取得する。
	 *
	 * @return	ブロック開始アクティビティインスタンスID
	 */
	public String getActID()
	{
		if (actID == null) return "";
		else return actID;
	}
	
	/**
	 * ブロック開始アクティビティインスタンスIDを設定する。
	 *
	 * @param	actID	ブロック開始アクティビティインスタンスID
	 */
	public void setActID(String actID)
	{
		this.actID = actID;
	}

	/**
	 * ガーベジコレクタによる当該オブジェクトの解放処理を行う。
	 *
	 * @throws	Throwable	任意の例外
	 */
	protected void finalize() throws Throwable
	{
		// ここに独自の解放処理を実装する。
		super.finalize();
	}
	
	/**
	 * 引数のオブジェクトとの比較を行い、同一性を判定する。
	 *
	 * @param	obj	比較するオブジェクト
	 * @return	判定結果
	 */
	public boolean equals(Object obj)
	{
		boolean b = super.equals(obj);
		return b;
	}
}

