/* $Id: WorkItem.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.wfmc;

import jp.co.argo21.nautica.workflow.omg.WfObject;

/**
 * 作業項目をあらわす。
 * 作業項目とは、ワークフロー参加者とアクティビティを結びつける情報であり、
 * プロセスインスタンス内の１つのアクティビティにおいて、
 * ワークフロー参加者によって処理されるべき仕事を表現したものである。
 * ユーザは、作業項目のIDを通じて、プロセス変数の取得、更新を行い、
 * 作業を完了させるものとする。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public interface WorkItem extends WfObject
{
	/**
	 * 作業項目IDを取得する。
	 *
	 * @return	作業項目ID
	 */
	public String getID();
	
	/**
	 * 作業項目IDを設定する。
	 *
	 * @param	workID	作業項目ID
	 */
	public void setID(String workID);

	/**
	 * プロセスインスタンスIDを取得する。
	 *
	 * @return	プロセスインスタンスID
	 */
	public String getProcessID();
	
	/**
	 * プロセスインスタンスIDを設定する。
	 *
	 * @param	procID	プロセスインスタンスID
	 */
	public void setProcessID(String procID);

	/**
	 * アクティビティインスタンスIDを取得する。
	 *
	 * @return	アクティビティインスタンスID
	 */
	public String getActivityID();
	
	/**
	 * アクティビティインスタンスIDを設定する。
	 *
	 * @param	actID	アクティビティインスタンスID
	 */
	public void setActivityID(String actID);

	/**
	 * 作業項目名を取得する。
	 *
	 * @return	作業項目名
	 */
	public String getName();

	/**
	 * ワークフロー参加者型を取得する。
	 *
	 * @return	ワークフロー参加者型
	 */
	public int getParticipantType();
	
	/**
	 * ワークフロー参加者型を設定する。
	 *
	 * @param	participantType	ワークフロー参加者型
	 */
	public void setParticipantType(int participantType);

	/**
	 * ワークフロー参加者名称を取得する。
	 *
	 * @return	ワークフロー参加者名称
	 */
	public String getParticipantName();
	
	/**
	 * ワークフロー参加者名称を設定する。
	 *
	 * @param	participantName	ワークフロー参加者名称
	 */
	public void setParticipantName(String participantName);
}
