/* $Id: ToolAgent.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.wfmc;


/**
 * ToolAgentは、ワークフローアプリケーションの実行を管理するエージェントの
 * 基底インタフェースである。これは、WfMCのインタフェース3に示される
 * ツールエージェントの概念に該当する。個別のツールエージェントの実装方法は
 * ここでは規定しないが、WfMCの仕様書からは、内部に実行要求のための
 * 待ち行列のようなものを想定している。
 * 本ワークフローシステム運用基盤で標準提供するツールエージェントの個別実装は、
 * この考え方を適用する。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public interface ToolAgent {

	/**
	 * アプリケーションの起動を行う。
	 * <b>制限事項</b>として、本ワークフローシステム運用基盤では、
	 * 引数にモードは含まないものとする。
	 * 
	 * @param appName 定義に指定したアプリケーション名
	 * @param wid 作業項目ID
	 * @param attrList 属性一覧
	 * @return ツールエージェントハンドル
	 * @throws ApplicationNotStartedException アプリケーションが開始できなかった場合
	 * @throws ApplicationNotDefinedException アプリケーションが定義されていない場合
	 * @throws ApplicationBusyException アプリケーションがビジーで要求を受けられない場合
	 */
	public int invokeApplication(String appName,
			String wid, Attribute[] attrList)
	throws ApplicationNotStartedException,
		ApplicationNotDefinedException, ApplicationBusyException;
	
	/**
	 * アプリケーションの実行状態を取得する。
	 * 実行状態は、以下のものを用意する。
	 * <ul>
	 * <li>0：正常終了</li>
	 * <li>1：異常終了</li>
	 * <li>2：未開始</li>
	 * <li>3：停止中</li>
	 * <li>6：実行中</li>
	 * <li>9：識別不可</li>
	 * </ul>
	 * <b>制限事項</b>として、本ワークフローシステム運用基盤では、
	 * 属性については、ツールエージェント、またはアプリケーションから
	 * 更新されると想定し、引数には含まないこととする。
	 * 
	 * @param toolAgentHandle ツールエージェントハンドル
	 * @param wid 作業項目ID
	 * @return 実行状態
	 * @throws ApplicationBusyException アプリケーションがビジーで要求を受けられない場合
	 * @throws InvalidToolAgentException 有効でないツールエージェントハンドルを指定した場合
	 * @throws InvalidWorkItemException 有効でない作業項目IDを指定した場合
	 */
	public int requestAppStatus(int toolAgentHandle, String wid)
	throws ApplicationBusyException, InvalidToolAgentException,
		InvalidWorkItemException;

	/**
	 * アプリケーションの停止を行う。
	 *
	 * @param toolAgentHandle ツールエージェントハンドル
	 * @param wid 作業項目ID
	 * @throws ApplicationNotStoppedException アプリケーションを停止できなかった場合
	 * @throws InvalidToolAgentException 有効でないツールエージェントハンドルを指定した場合
	 * @throws InvalidWorkItemException 有効でない作業項目IDを指定した場合
	 * @throws ApplicationBusyException アプリケーションがビジーで要求を受けられない場合
	 */
	public void terminateApplication(int toolAgentHandle, String wid)
	throws ApplicationNotStoppedException, InvalidToolAgentException,
		InvalidWorkItemException, ApplicationBusyException;
}
