/* $Id: Process.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.wfmc;

import java.sql.Timestamp;

import jp.co.argo21.nautica.workflow.omg.WfObject;

/**
 * プロセスインスタンスを表すインタフェースである。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public interface Process extends WfObject
{
	/**
	 * プロセスインスタンスIDを取得する。
	 *
	 * @return	プロセスインスタンスID
	 */
	public String getID();
	
	/**
	 * プロセスインスタンスIDを設定する。
	 *
	 * @param	procID	プロセスインスタンスID
	 */
	public void setID(String procID);

	/**
	 * プロセスインスタンス名を取得する。
	 *
	 * @return	プロセスインスタンス名
	 */
	public String getName();
	
	/**
	 * プロセスインスタンス名を設定する。
	 *
	 * @param	procName	プロセスインスタンス名
	 */
	public void setName(String procName);

	/**
	 * パッケージIDを取得する。
	 *
	 * @return	パッケージID
	 */
	public String getPackageID();
	
	/**
	 * パッケージIDを設定する。
	 *
	 * @param	packageID	パッケージID
	 */
	public void setPackageID(String packageID);

	/**
	 * プロセス定義IDを取得する。
	 *
	 * @return	プロセス定義ID
	 */
	public String getProcDefinitionID();
	
	/**
	 * プロセス定義IDを設定する。
	 *
	 * @param	procDefID	プロセス定義ID
	 */
	public void setProcDefinitionID(String procDefID);

	/**
	 * 開始日時を取得する。
	 *
	 * @return	開始日時
	 */
	public Timestamp getStartDate();
	
	/**
	 * 開始日時を設定する。
	 *
	 * @param	startDate	開始日時
	 */
	public void setStartDate(Timestamp startDate);

	/**
	 * 開始者を取得する。
	 *
	 * @return	開始者
	 */
	public String getStarterID();
	
	/**
	 * 開始者を設定する。
	 *
	 * @param	starterID	開始者
	 */
	public void setStarterID(String starterID);

	/**
	 * 実行期限を取得する。
	 *
	 * @return	実行期限
	 */
	public Timestamp getDurationLimit();
	
	/**
	 * 実行期限を設定する。
	 *
	 * @param	durationLimit	実行期限
	 */
	public void setDurationLimit(Timestamp durationLimit);

	/**
	 * 状態を取得する。
	 *
	 * @return	状態
	 */
	public int getProcessState();
	
	/**
	 * 状態を設定する。
	 *
	 * @param	procState	状態
	 */
	public void setProcessState(int procState);

	/**
	 * 最新状態更新日時を取得する。
	 *
	 * @return	最新状態更新日時
	 */
	public Timestamp getUpdateDate();
	
	/**
	 * 最新状態更新日時を設定する。
	 *
	 * @param	updateDate	最新状態更新日時
	 */
	public void setUpdateDate(Timestamp updateDate);
}
