/* $Id: DefinitionRepository.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.wfmc;

import jp.co.argo21.nautica.workflow.omg.WorkflowException;

/**
 * DefinitionRepositoryは、XPDLファイルと名称のマッピングを管理しており、
 * 要求に応じて、XPDLをオブジェクト化して返す。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public interface DefinitionRepository
{
	/**
	 * 指定された定義の登録処理を行い、エンジンに認識させる。
	 *
	 * @param session セッションID
	 * @param name ワークフロー定義名
	 * @param path ワークフロー定義の相対パス
	 * @throws InvalidSessionException 指定されたセッションが無効の場合
	 * @throws WorkflowException プロセスインスタンスIDが有効でない場合
	 */
	public void registerDefinition(String session, String name, String path)
	throws InvalidSessionException, WorkflowException;

	/**
	 * 条件にマッチしたプロセス定義一覧を返す。
	 *
	 * @param session セッションID
	 * @param filter 検索用フィルター
	 * @return 検索されたプロセス定義概要の配列
	 * @throws InvalidSessionException 指定されたセッションが無効の場合
	 * @throws InvalidFilterException 指定されたフィルターが有効でない場合
	 */
	public ProcDef[] getProcessDefinitions(
			String session, Filter filter)
	throws InvalidSessionException, InvalidFilterException;

	/**
	 * プロセス定義IDで特定された定義の現在の状態から遷移可能な
	 * プロセス定義状態一覧を返す。
	 *
	 * @param session セッションID
	 * @param pdid プロセス定義ID
	 * @return プロセス定義状態の配列
	 * @throws InvalidSessionException 指定されたセッションが無効の場合
	 * @throws InvalidProcessDefinitionException 指定されたプロセス定義IDが有効でない場合
	 */
	public ProcessDefinitionState[] getProcessDefinitionStates(
			String session,String pdid)
	throws InvalidSessionException, InvalidProcessDefinitionException;

	/**
	 * プロセス定義状態を変更する。
	 *
	 * @param session セッションID
	 * @param pdid プロセス定義ID
	 * @param state プロセス定義状態
	 * @throws InvalidSessionException 指定されたセッションが無効の場合
	 * @throws InvalidProcessDefinitionException 指定されたプロセス定義IDが有効でない場合
	 * @throws InvalidStateException 指定された状態が有効でない場合
	 * @throws TransitionNotAllowedException 状態の変更が許可されていない場合
	 */
	public void changeProcessDefinitionState (String session,
			String pdid, ProcessDefinitionState state)
	throws InvalidSessionException, InvalidProcessDefinitionException,
		InvalidStateException, TransitionNotAllowedException;
}
